/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.AddCheckConstraintStatement;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DisableCheckConstraintStatement;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class AddCheckConstraintGenerator
extends AbstractSqlGenerator<AddCheckConstraintStatement> {
    public boolean supports(AddCheckConstraintStatement addCheckConstraintStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase && ((MySQLDatabase)database).isMinimumMySQLVersion("8.0.16") || database instanceof AbstractDb2Database || database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(AddCheckConstraintStatement addCheckConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        database = new ValidationErrors();
        database.checkRequiredField("constraintBody", (Object)addCheckConstraintStatement.getConstraintBody());
        database.checkRequiredField("constraintName", (Object)addCheckConstraintStatement.getConstraintName());
        database.checkRequiredField("tableName", (Object)addCheckConstraintStatement.getTableName());
        return database;
    }

    public Sql[] generateSql(AddCheckConstraintStatement abstractSqlStatement, Database database, SqlGeneratorChain object) {
        object = new ArrayList();
        String string = String.format("ALTER TABLE %s ADD CONSTRAINT %s CHECK (%s)", database.escapeTableName(abstractSqlStatement.getCatalogName(), abstractSqlStatement.getSchemaName(), abstractSqlStatement.getTableName()), database.escapeConstraintName(abstractSqlStatement.getConstraintName()), abstractSqlStatement.getConstraintBody());
        if (database instanceof OracleDatabase) {
            string = string + (abstractSqlStatement.isDisabled() ? " DISABLE " : "");
            string = string + (!abstractSqlStatement.isValidate() && !abstractSqlStatement.isDisabled() ? " ENABLE NOVALIDATE " : "");
        }
        object.add(new UnparsedSql(string, new DatabaseObject[]{this.getAffectedCheckConstraint((AddCheckConstraintStatement)abstractSqlStatement)}));
        if (abstractSqlStatement.isDisabled() && !(database instanceof OracleDatabase)) {
            abstractSqlStatement = new DisableCheckConstraintStatement(abstractSqlStatement.getCatalogName(), abstractSqlStatement.getSchemaName(), abstractSqlStatement.getTableName(), abstractSqlStatement.getConstraintName());
            object.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql((SqlStatement)abstractSqlStatement, database)));
        }
        Object object2 = object;
        return object2.toArray(new Sql[object2.size()]);
    }

    protected CheckConstraint getAffectedCheckConstraint(AddCheckConstraintStatement addCheckConstraintStatement) {
        return new CheckConstraint().setName(addCheckConstraintStatement.getConstraintName()).setTable((Table)new Table().setName(addCheckConstraintStatement.getTableName()).setSchema(addCheckConstraintStatement.getCatalogName(), addCheckConstraintStatement.getSchemaName()));
    }
}

