/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement;

import java.util.List;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.UserVariable;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;

public class OutputClause {
    List<SelectItem> selectItemList;
    UserVariable tableVariable;
    Table outputTable;
    List<String> columnList;

    public OutputClause(List<SelectItem> list, UserVariable userVariable, Table table, List<String> list2) {
        this.selectItemList = Objects.requireNonNull(list, "The Select List of the Output Clause must not be null.");
        this.tableVariable = userVariable;
        this.outputTable = table;
        this.columnList = list2;
    }

    public List<SelectItem> getSelectItemList() {
        return this.selectItemList;
    }

    public void setSelectItemList(List<SelectItem> list) {
        this.selectItemList = list;
    }

    public UserVariable getTableVariable() {
        return this.tableVariable;
    }

    public void setTableVariable(UserVariable userVariable) {
        this.tableVariable = userVariable;
    }

    public Table getOutputTable() {
        return this.outputTable;
    }

    public void setOutputTable(Table table) {
        this.outputTable = table;
    }

    public List<String> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(List<String> list) {
        this.columnList = list;
    }

    public StringBuilder appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(" OUTPUT ");
        PlainSelect.appendStringListTo(stringBuilder, this.selectItemList, true, false);
        if (this.tableVariable != null) {
            stringBuilder.append(" INTO ").append(this.tableVariable);
        } else if (this.outputTable != null) {
            stringBuilder.append(" INTO ").append(this.outputTable);
        }
        PlainSelect.appendStringListTo(stringBuilder, this.columnList, true, false);
        return stringBuilder.append(" ");
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

