/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;

public class UpdateSet {
    protected boolean usingBracketsForColumns = false;
    protected boolean usingBracketsForValues = false;
    protected ArrayList<Column> columns = new ArrayList();
    protected ArrayList<Expression> expressions = new ArrayList();

    public UpdateSet() {
    }

    public UpdateSet(Column column) {
        this.columns.add(column);
    }

    public UpdateSet(Column column, Expression expression) {
        this.columns.add(column);
        this.expressions.add(expression);
    }

    public boolean isUsingBracketsForValues() {
        return this.usingBracketsForValues;
    }

    public void setUsingBracketsForValues(boolean bl2) {
        this.usingBracketsForValues = bl2;
    }

    public boolean isUsingBracketsForColumns() {
        return this.usingBracketsForColumns;
    }

    public void setUsingBracketsForColumns(boolean bl2) {
        this.usingBracketsForColumns = bl2;
    }

    public ArrayList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ArrayList<Column> arrayList) {
        this.columns = Objects.requireNonNull(arrayList);
    }

    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ArrayList<Expression> arrayList) {
        this.expressions = Objects.requireNonNull(arrayList);
    }

    public void add(Column column, Expression expression) {
        this.columns.add(column);
        this.expressions.add(expression);
    }

    public void add(Column column) {
        this.columns.add(column);
    }

    public void add(Expression expression) {
        this.expressions.add(expression);
    }

    public void add(ExpressionList expressionList) {
        this.expressions.addAll(expressionList.getExpressions());
    }

    public static final StringBuilder appendUpdateSetsTo(StringBuilder stringBuilder, Collection<UpdateSet> object) {
        stringBuilder.append(" SET ");
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            ((UpdateSet)object.next()).appendTo(stringBuilder, n2);
            ++n2;
        }
        return stringBuilder;
    }

    StringBuilder appendTo(StringBuilder stringBuilder, int n2) {
        if (n2 > 0) {
            stringBuilder.append(", ");
        }
        if (this.usingBracketsForColumns) {
            stringBuilder.append("(");
        }
        for (n2 = 0; n2 < this.columns.size(); ++n2) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.columns.get(n2));
        }
        if (this.usingBracketsForColumns) {
            stringBuilder.append(")");
        }
        stringBuilder.append(" = ");
        if (this.usingBracketsForValues) {
            stringBuilder.append("(");
        }
        for (n2 = 0; n2 < this.expressions.size(); ++n2) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.expressions.get(n2));
        }
        if (this.usingBracketsForValues) {
            stringBuilder.append(")");
        }
        return stringBuilder;
    }
}

