/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.statement.Block;
import liquibase.repackaged.net.sf.jsqlparser.statement.Commit;
import liquibase.repackaged.net.sf.jsqlparser.statement.CreateFunctionalStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.DeclareStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.DescribeStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ExplainStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ExplainStatement$Option;
import liquibase.repackaged.net.sf.jsqlparser.statement.IfElseStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.PurgeStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ResetStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.RollbackStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.SavepointStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.SetStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ShowColumnsStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ShowStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.repackaged.net.sf.jsqlparser.statement.UnsupportedStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.UseStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.Alter;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterSession;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterSystemStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.RenameTableStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.analyze.Analyze;
import liquibase.repackaged.net.sf.jsqlparser.statement.comment.Comment;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.index.CreateIndex;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.schema.CreateSchema;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.AlterView;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.CreateView;
import liquibase.repackaged.net.sf.jsqlparser.statement.delete.Delete;
import liquibase.repackaged.net.sf.jsqlparser.statement.drop.Drop;
import liquibase.repackaged.net.sf.jsqlparser.statement.execute.Execute;
import liquibase.repackaged.net.sf.jsqlparser.statement.grant.Grant;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.Insert;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.Merge;
import liquibase.repackaged.net.sf.jsqlparser.statement.replace.Replace;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.show.ShowTablesStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.truncate.Truncate;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.Update;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.Upsert;
import liquibase.repackaged.net.sf.jsqlparser.statement.values.ValuesStatement;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AlterDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AlterSequenceDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AlterSessionDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AlterViewDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateIndexDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateSequenceDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateSynonymDeparser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateTableDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateViewDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.DeclareStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.DeleteDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.DropDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExecuteDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.GrantDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.InsertDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ReplaceDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ResetStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.SelectDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.SetStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ShowColumnsStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ShowStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ShowTablesStatementDeparser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.UpdateDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.UpsertDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.UseStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ValuesStatementDeParser;

public class StatementDeParser
extends AbstractDeParser<Statement>
implements StatementVisitor {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public StatementDeParser(StringBuilder stringBuilder) {
        this(new ExpressionDeParser(), new SelectDeParser(), stringBuilder);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
    }

    @Override
    public void visit(CreateIndex createIndex) {
        new CreateIndexDeParser(this.buffer).deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        StatementDeParser statementDeParser = this;
        new CreateTableDeParser(statementDeParser, statementDeParser.buffer).deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        new CreateViewDeParser(this.buffer).deParse(createView);
    }

    @Override
    public void visit(AlterView alterView) {
        new AlterViewDeParser(this.buffer).deParse(alterView);
    }

    @Override
    public void visit(Delete delete) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        new DeleteDeParser(this.expressionDeParser, this.buffer).deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
        new DropDeParser(this.buffer).deParse(drop);
    }

    @Override
    public void visit(Insert insert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer).deParse(insert);
    }

    @Override
    public void visit(Replace replace) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        new ReplaceDeParser(this.expressionDeParser, this.selectDeParser, this.buffer).deParse(replace);
    }

    @Override
    public void visit(Select select) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            if (select.isUsingWithBrackets()) {
                this.buffer.append("( ");
            }
            this.buffer.append("WITH ");
            Iterator<WithItem> iterator = select.getWithItemsList().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this.selectDeParser);
                if (iterator.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(this.selectDeParser);
        if (select.isUsingWithBrackets()) {
            this.buffer.append(" )");
        }
    }

    @Override
    public void visit(Truncate truncate) {
        this.buffer.append("TRUNCATE");
        if (truncate.isTableToken()) {
            this.buffer.append(" TABLE");
        }
        if (truncate.isOnly()) {
            this.buffer.append(" ONLY");
        }
        this.buffer.append(" ");
        this.buffer.append(truncate.getTable());
        if (truncate.getCascade()) {
            this.buffer.append(" CASCADE");
        }
    }

    @Override
    public void visit(Update update) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        updateDeParser.deParse(update);
    }

    @Override
    public void visit(Analyze analyze) {
        this.buffer.append("ANALYZE ");
        this.buffer.append(analyze.getTable());
    }

    @Override
    public void visit(Alter alter) {
        new AlterDeParser(this.buffer).deParse(alter);
    }

    @Override
    public void visit(Statements statements) {
        statements.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        ExecuteDeParser executeDeParser = new ExecuteDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        executeDeParser.deParse(execute);
    }

    @Override
    public void visit(SetStatement setStatement) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        SetStatementDeParser setStatementDeParser = new SetStatementDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        setStatementDeParser.deParse(setStatement);
    }

    @Override
    public void visit(ResetStatement resetStatement) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        ResetStatementDeParser resetStatementDeParser = new ResetStatementDeParser(this.expressionDeParser, this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        resetStatementDeParser.deParse(resetStatement);
    }

    @Override
    public void visit(Merge merge) {
        this.buffer.append(merge.toString());
    }

    @Override
    public void visit(SavepointStatement savepointStatement) {
        this.buffer.append(savepointStatement.toString());
    }

    @Override
    public void visit(RollbackStatement rollbackStatement) {
        this.buffer.append(rollbackStatement.toString());
    }

    @Override
    public void visit(Commit commit) {
        this.buffer.append(commit.toString());
    }

    @Override
    public void visit(Upsert upsert) {
        this.selectDeParser.setBuffer(this.buffer);
        this.expressionDeParser.setSelectVisitor(this.selectDeParser);
        this.expressionDeParser.setBuffer(this.buffer);
        this.selectDeParser.setExpressionVisitor(this.expressionDeParser);
        new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer).deParse(upsert);
    }

    @Override
    public void visit(UseStatement useStatement) {
        new UseStatementDeParser(this.buffer).deParse(useStatement);
    }

    @Override
    public void visit(ShowColumnsStatement showColumnsStatement) {
        new ShowColumnsStatementDeParser(this.buffer).deParse(showColumnsStatement);
    }

    @Override
    public void visit(ShowTablesStatement showTablesStatement) {
        new ShowTablesStatementDeparser(this.buffer).deParse(showTablesStatement);
    }

    @Override
    public void visit(Block object) {
        this.buffer.append("BEGIN\n");
        if (((Block)object).getStatements() != null) {
            object = ((Block)object).getStatements().getStatements().iterator();
            while (object.hasNext()) {
                ((Statement)object.next()).accept(this);
                this.buffer.append(";\n");
            }
        }
        this.buffer.append("END");
    }

    @Override
    public void visit(Comment comment) {
        this.buffer.append(comment.toString());
    }

    @Override
    public void visit(ValuesStatement valuesStatement) {
        this.expressionDeParser.setBuffer(this.buffer);
        new ValuesStatementDeParser(this.expressionDeParser, this.buffer).deParse(valuesStatement);
    }

    @Override
    public void visit(DescribeStatement describeStatement) {
        this.buffer.append("DESCRIBE ");
        this.buffer.append(describeStatement.getTable());
    }

    @Override
    public void visit(ExplainStatement explainStatement) {
        this.buffer.append("EXPLAIN ");
        if (explainStatement.getOptions() != null) {
            this.buffer.append(explainStatement.getOptions().values().stream().map(ExplainStatement$Option::formatOption).collect(Collectors.joining(" ")));
            this.buffer.append(" ");
        }
        explainStatement.getStatement().accept(this);
    }

    @Override
    public void visit(ShowStatement showStatement) {
        new ShowStatementDeParser(this.buffer).deParse(showStatement);
    }

    @Override
    public void visit(DeclareStatement declareStatement) {
        this.expressionDeParser.setBuffer(this.buffer);
        new DeclareStatementDeParser(this.expressionDeParser, this.buffer).deParse(declareStatement);
    }

    @Override
    public void visit(Grant grant) {
        new GrantDeParser(this.buffer).deParse(grant);
    }

    @Override
    public void visit(CreateSchema createSchema) {
        this.buffer.append(createSchema.toString());
    }

    @Override
    public void visit(CreateSequence createSequence) {
        new CreateSequenceDeParser(this.buffer).deParse(createSequence);
    }

    @Override
    public void visit(AlterSequence alterSequence) {
        new AlterSequenceDeParser(this.buffer).deParse(alterSequence);
    }

    @Override
    public void visit(CreateFunctionalStatement createFunctionalStatement) {
        this.buffer.append(createFunctionalStatement.toString());
    }

    @Override
    public void visit(CreateSynonym createSynonym) {
        new CreateSynonymDeparser(this.buffer).deParse(createSynonym);
    }

    @Override
    void deParse(Statement statement) {
        statement.accept(this);
    }

    @Override
    public void visit(AlterSession alterSession) {
        new AlterSessionDeParser(this.buffer).deParse(alterSession);
    }

    @Override
    public void visit(IfElseStatement ifElseStatement) {
        ifElseStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(RenameTableStatement renameTableStatement) {
        renameTableStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(PurgeStatement purgeStatement) {
        purgeStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(AlterSystemStatement alterSystemStatement) {
        alterSystemStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(UnsupportedStatement unsupportedStatement) {
        unsupportedStatement.appendTo(this.buffer);
    }
}

