/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.DeploymentIdFilter;
import com.datical.liquibase.ext.command.InternalRollbackOneUpdateCommandStep$1;
import com.datical.liquibase.ext.command.RollbackOneUpdateCommandStep;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubUpdater;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.Operation;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;

public class InternalRollbackOneUpdateCommandStep
extends AbstractCommandStep {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    public static final String[] COMMAND_NAME = new String[]{"internalRollbackOneUpdate"};
    public static final CommandArgumentDefinition<String> CHANGE_LOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> DEPLOYMENT_ID_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    public static final CommandArgumentDefinition<Database> DATABASE_ARG;
    public static final CommandArgumentDefinition<Liquibase> LIQUIBASE_ARG;
    public static final CommandArgumentDefinition<ChangeLogParameters> CHANGE_LOG_PARAMETERS_ARG;
    private Database database;
    private String deploymentId;
    private String changeLogFilePath;
    protected Writer outputWriter;
    private ChangeLogParameters changeLogParameters;
    private Boolean force;
    private DatabaseChangeLog changeLog;
    private Liquibase liquibase;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private String rollbackScript;
    private ChangeExecListener changeExecListener;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    public void validate(CommandScope commandScope) {
        super.validate(commandScope);
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected RollbackVisitor createRollbackVisitor(List<ChangesetsRolledback.ChangeSet> list) {
        return new RollbackVisitor(this.database, this.changeExecListener, list);
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run((ChangeSetVisitor)new InternalRollbackOneUpdateCommandStep$1(this), new RuntimeEnvironment(this.database, contexts, labelExpression));
    }

    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void run(CommandResultsBuilder object) {
        Object object2;
        Object object3;
        LoggingExecutor loggingExecutor;
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])RollbackOneUpdateCommandStep.COMMAND_NAME);
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        object = object.getCommandScope();
        this.deploymentId = (String)object.getArgumentValue(DEPLOYMENT_ID_ARG);
        this.force = (Boolean)object.getArgumentValue(FORCE_ARG);
        if (this.force == null || !this.force.booleanValue()) {
            object = "\nWARNING: Targeted rollback of this update may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-update-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(String.format((String)object, new Object[0]));
        }
        this.rollbackScript = (String)object.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        this.changeLogParameters = (ChangeLogParameters)object.getArgumentValue(CHANGE_LOG_PARAMETERS_ARG);
        this.changeLogFilePath = (String)object.getArgumentValue(CHANGE_LOG_FILE_ARG);
        this.changeLog = this.parseChangeLogFile(this.changeLogFilePath, this.changeLogParameters);
        this.liquibase = (Liquibase)object.getArgumentValue(LIQUIBASE_ARG);
        this.database = (Database)object.getArgumentValue(DATABASE_ARG);
        this.force = (Boolean)object.getArgumentValue(FORCE_ARG);
        Scope.getCurrentScope().addMdcValue("rollbackScript", this.rollbackScript);
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", this.database.getConnection().getURL());
        Scope.getCurrentScope().addMdcValue("rollbackOneUpdateForce", String.valueOf(this.force));
        object = "rollbackOneUpdate";
        Executor executor = null;
        if (this.outputWriter != null) {
            object = "rollback-one-update-sql";
            executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            loggingExecutor = new LoggingExecutor(executor, this.outputWriter, this.database);
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", this.database, (Executor)loggingExecutor);
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("logging", this.database, (Executor)loggingExecutor);
        } else {
            loggingExecutor = new LoggingExecutor(executor, null, this.database);
        }
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("logging", this.database, (Executor)loggingExecutor);
        loggingExecutor = null;
        HubUpdater hubUpdater = new HubUpdater(new Date(), this.changeLog, this.database);
        BufferedLogService bufferedLogService = new BufferedLogService();
        Object object4 = this.database.getRanChangeSetList();
        if (this.deploymentId == null) {
            this.deploymentId = ((AbstractChangeLogHistoryService)ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database)).getLastDeploymentId();
            if (this.deploymentId == null) {
                throw new LiquibaseException(String.format(coreBundle.getString("no.deployment.ids.found"), new Object[0]));
            }
            Scope.getCurrentScope().getUI().sendMessage("Defaulting to last deployment ID '" + this.deploymentId + "'");
        } else {
            boolean bl2 = false;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (RanChangeSet)object3.next();
                if (!this.deploymentId.equals(object2.getDeploymentId())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                object3 = String.format(coreBundle.getString("no.change.sets.found.for.deployment.id"), this.deploymentId);
                throw new LiquibaseException("\n".concat(String.valueOf(object3)));
            }
        }
        this.liquibase.outputHeader("Rollback deployment ID '" + this.deploymentId + "'");
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, this.changeLog, this.contexts, this.labelExpression);
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            object3 = new DeploymentIdFilter(this.deploymentId, this.database, (List<RanChangeSet>)object4, this.changeLog, (String)object);
            if (!((DeploymentIdFilter)object3).getNoInverseChangeSets().isEmpty()) {
                object2 = "\n\nThere are changesets associated with the deployment ID '" + this.deploymentId + "' which cannot be rolled back.\nNo rollback was performed.\n";
                object2 = (String)object2 + "\nChangesets which cannot be rolled back:\n";
                for (Map.Entry<String, ChangeSet> entry : ((DeploymentIdFilter)object3).getNoInverseChangeSets().entrySet()) {
                    object2 = (String)object2 + entry.getKey();
                    object2 = (String)object2 + "\n";
                }
                throw new LiquibaseException("\n".concat(String.valueOf(object2)));
            }
            if (((DeploymentIdFilter)object3).isEmpty()) {
                object2 = "\n\nThere are no changesets associated with the deployment ID '" + this.deploymentId + "'.\nPlease check your parameters.  No rollback was performed.\n";
                throw new LiquibaseException("\n".concat(String.valueOf(object2)));
            }
            object2 = this.createChangeLogIterator((List<RanChangeSet>)object4, (ChangeSetFilter)object3);
            object = this.outputWriter == null ? this.liquibase.getConnection(this.changeLog) : null;
            if (object != null) {
                loggingExecutor = hubUpdater.preUpdateHub("ROLLBACK", "rollback-one-update", (Connection)object, this.changeLogFilePath, this.contexts, this.labelExpression, (ChangeLogIterator)object2);
                this.changeExecListener = new HubChangeExecListener((Operation)loggingExecutor, this.changeExecListener);
            }
            object4 = this.createChangeLogIterator((List<RanChangeSet>)object4, (ChangeSetFilter)object3);
            CompositeLogService compositeLogService = new CompositeLogService(true, new LogService[]{bufferedLogService});
            object = new ArrayList();
            Scope.child((String)Scope.Attr.logService.name(), (Object)compositeLogService, () -> this.lambda$run$0(object4, (List)object));
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback((List)object), false);
            hubUpdater.postUpdateHub((Operation)loggingExecutor, bufferedLogService);
            object = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");
            object4 = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
            }
            catch (Throwable throwable) {
                object3 = throwable;
                object4 = throwable;
                throw object3;
            }
            finally {
                if (object != null) {
                    if (object4 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (LiquibaseException liquibaseException) {
            hubUpdater.postUpdateHubExceptionHandling((Operation)loggingExecutor, bufferedLogService, liquibaseException.getMessage());
            object2 = liquibaseException.getCause();
            object = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");
            object4 = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                object4 = throwable;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (object4 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        object.close();
                    }
                }
            }
            if (object2 instanceof RollbackImpossibleException) {
                object = "\nError executing rollback:\nThe rollback for deployment ID '" + this.deploymentId + "' has at least one changeset without a rollback defined\nPlease add a rollback change in the appropriate changeset.\n";
                logger.severe((String)object, (Throwable)liquibaseException);
                if (this.changeExecListener != null) {
                    this.changeExecListener.runFailed(null, this.changeLog, this.database, (Exception)((Object)liquibaseException));
                }
                throw new LiquibaseException((String)object, (Throwable)liquibaseException);
            }
            logger.severe("\nError executing rollback for the deployment ID '" + this.deploymentId + "'.");
            throw new LiquibaseException("\nError executing rollback for the deployment ID '" + this.deploymentId + "':\n" + liquibaseException.getMessage(), (Throwable)liquibaseException);
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(MSG_COULD_NOT_RELEASE_LOCK, (Throwable)lockException);
            }
            if (executor != null) {
                ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", this.database, executor);
            }
        }
        this.resetServices();
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-update executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private String getLastDeploymentId(List<RanChangeSet> object) {
        if (object == null || object.size() == 0) {
            return null;
        }
        List<RanChangeSet> list = object;
        object = list.get(list.size() - 1).getDeploymentId();
        if (object == null) {
            return null;
        }
        return object;
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, new ChangeSetFilter[]{changeSetFilter, new AlreadyRanChangeSetFilter(list), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database)});
    }

    protected void checkLiquibaseTables(boolean bl2, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
        if (bl2) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).reset();
    }

    private DatabaseChangeLog parseChangeLogFile(String string, ChangeLogParameters changeLogParameters) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        return ChangeLogParserFactory.getInstance().getParser(string, resourceAccessor).parse(string, changeLogParameters, resourceAccessor);
    }

    private /* synthetic */ void lambda$run$0(ChangeLogIterator changeLogIterator, List list) {
        changeLogIterator.run((ChangeSetVisitor)this.createRollbackVisitor(list), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGE_LOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().build();
        DEPLOYMENT_ID_ARG = commandBuilder.argument("deploymentId", String.class).build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).build();
        DATABASE_ARG = commandBuilder.argument("database", Database.class).required().build();
        LIQUIBASE_ARG = commandBuilder.argument("liquibase", Liquibase.class).required().build();
        CHANGE_LOG_PARAMETERS_ARG = commandBuilder.argument("changeLogParameters", ChangeLogParameters.class).build();
    }
}

