/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.init;

import com.datical.liquibase.ext.copy.ProjectCopier;
import com.datical.liquibase.ext.copy.ProjectCopierFactory;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.UnexpectedLiquibaseException;

public class InitCopyCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "copy"};
    public static final CommandArgumentDefinition<String> INIT_COPY_SOURCE_DIR_ARG;
    public static final CommandArgumentDefinition<String> INIT_COPY_TARGET_DIR_ARG;
    public static final CommandArgumentDefinition<Boolean> INIT_COPY_RECURSIVE_ARG;
    public static final CommandArgumentDefinition<ProjectCopier> INIT_COPY_PROJECT_COPIER_ARG;

    public final void run(CommandResultsBuilder commandResultsBuilder) {
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        Object object = commandScope.getConfiguredValue(INIT_COPY_SOURCE_DIR_ARG);
        Object object2 = commandScope.getConfiguredValue(INIT_COPY_TARGET_DIR_ARG);
        Object object3 = commandScope.getConfiguredValue(INIT_COPY_RECURSIVE_ARG);
        object = (String)object.getValue();
        object2 = (String)object2.getValue();
        object3 = (Boolean)object3.getValue();
        this.determineProjectCopier(commandScope, (String)object2).copy((String)object, (String)object2, (Boolean)object3);
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Copy project files from the source directory to the target directory.");
        commandDefinition.setGroupShortDescription(new String[]{"init"}, "Init commands");
    }

    private ProjectCopier determineProjectCopier(CommandScope object, String string) {
        if ((object = (ProjectCopier)object.getConfiguredValue(INIT_COPY_PROJECT_COPIER_ARG).getValue()) != null) {
            return object;
        }
        object = ((ProjectCopierFactory)Scope.getCurrentScope().getSingleton(ProjectCopierFactory.class)).getProjectCopier(string);
        if (object == null) {
            throw new UnexpectedLiquibaseException("Unable to locate a ProjectCopier instance on the classpath for '" + string + "'");
        }
        return object;
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        INIT_COPY_SOURCE_DIR_ARG = commandBuilder.argument("source", String.class).description("Path to the directory where the project files will be created").build();
        INIT_COPY_TARGET_DIR_ARG = commandBuilder.argument("target", String.class).description("Source directory where the project files will be copied from").defaultValue((Object)".").build();
        INIT_COPY_RECURSIVE_ARG = commandBuilder.argument("recursive", Boolean.class).description("Recursive copy files from the source directory").defaultValue((Object)Boolean.FALSE).build();
        INIT_COPY_PROJECT_COPIER_ARG = commandBuilder.argument("projectCopier", ProjectCopier.class).description("ProjectCopier object that can be passed in").hidden().build();
    }
}

