/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.List;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;

public abstract class AbstractLiquibaseBasicRule
extends AbstractLiquibaseRule {
    @Override
    public final boolean evaluate(Facts facts) {
        Database database;
        Object object = this.getChangeSetFromFacts(facts);
        LazyDatabaseSnapshot lazyDatabaseSnapshot = this.getSnapshotFromFacts(facts);
        boolean bl2 = false;
        if (object == null && lazyDatabaseSnapshot == null) {
            return false;
        }
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                boolean bl3;
                database = (ChangeSet)object.next();
                if (database == null || !this.shouldBeEvaluated((ChangeSet)database)) {
                    bl3 = this.putResultSuccessful((ChangeSet)database, false, null);
                } else {
                    bl3 = this.internalEvaluate((ChangeSet)database);
                    if (Boolean.TRUE.equals(this.getShouldCheckRollbackFromFacts(facts))) {
                        Database database2 = database;
                        this.internalRollbackEvaluate((ChangeSet)database2, database2.getRollback().getChanges());
                    }
                }
                if (bl2) continue;
                bl2 = bl3;
            }
        }
        if (lazyDatabaseSnapshot != null) {
            try {
                object = lazyDatabaseSnapshot.createDiffResult();
                database = lazyDatabaseSnapshot.getDatabase();
                for (DatabaseObject databaseObject : object.getMissingObjects()) {
                    if (database.isLiquibaseObject(databaseObject) || !this.shouldBeEvaluated(databaseObject)) continue;
                    boolean bl4 = this.internalEvaluate(databaseObject);
                    if (bl2) continue;
                    bl2 = bl4;
                }
            }
            catch (CommandExecutionException | DatabaseException | InvalidExampleException throwable) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to generate diff from database lazyDatabaseSnapshot, and thus failed to run the database checks.", throwable);
                this.putResultUnsuccessful((DatabaseObject)null, "Failed to generate diff from database lazyDatabaseSnapshot");
            }
        }
        return bl2;
    }

    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> list) {
        return false;
    }

    public abstract boolean internalEvaluate(ChangeSet var1);

    public abstract boolean internalEvaluate(DatabaseObject var1);
}

