/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;

public class MissingStoredProcedureChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (StoredProcedure.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        database2 = (StoredProcedure)databaseObject;
        changeGeneratorChain = new CreateProcedureChange();
        changeGeneratorChain.setProcedureText(database2.getBody());
        changeGeneratorChain.setProcedureName(database2.getName());
        if (diffOutputControl.getIncludeCatalog()) {
            changeGeneratorChain.setCatalogName(database2.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            changeGeneratorChain.setSchemaName(database2.getSchema().getName());
        }
        if (database instanceof MSSQLDatabase && !database2.getBody().toUpperCase().contains("AS EXTERNAL NAME")) {
            changeGeneratorChain.setReplaceIfExists(Boolean.TRUE);
        }
        return MissingStoredProcedureChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{changeGeneratorChain});
    }
}

