/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class PostgresStoredProcedureSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            try {
                if (database.getDatabaseMajorVersion() > 10) {
                    return super.getPriority(clazz, database);
                }
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    public PostgresStoredProcedureSnapshotGenerator() {
        super(StoredProcedure.class, new Class[]{Schema.class});
    }

    @Override
    protected String getObjectType(Database database) {
        return "PROCEDURE";
    }

    protected StoredDatabaseLogic<StoredProcedure> createReturnObject() {
        return new StoredProcedure();
    }

    @Override
    public String getAddToSql(Schema schema, Database database) {
        return String.format("select  pp.proname AS OBJECT_NAME, pp.proargnames AS OBJECT_ARG, pl.lanname as TYPE,'VALID' as STATUS, pg_get_functiondef(pp.oid) AS OBJECT_BODY \nfrom pg_proc pp \ninner join pg_namespace pn on (pp.pronamespace = pn.oid) inner join pg_language pl on (pp.prolang = pl.oid) where pn.nspname NOT LIKE 'pg_%%'   and pn.nspname = '%s'   and pp.prokind = 'p' ", schema.getName());
    }

    @Override
    public String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database object) {
        object = this.getAddToSql(storedDatabaseLogic.getSchema(), (Database)object);
        return (String)object + " and pp.proname = '" + storedDatabaseLogic.getName() + "' ";
    }

    @Override
    public void addTo(DatabaseObject databaseObject, DatabaseSnapshot object) {
        if (!(databaseObject instanceof Schema)) {
            return;
        }
        databaseObject = (Schema)databaseObject;
        Database object22 = object.getDatabase();
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", object22);
        for (Map map : this.queryForList((DatabaseSnapshot)object, (Schema)databaseObject, executor)) {
            String string = (String)map.get("OBJECT_NAME");
            String string2 = (String)map.get("TYPE");
            String string3 = (String)map.get("OBJECT_BODY");
            StoredDatabaseLogic storedDatabaseLogic = ((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema((Schema)databaseObject)).setName(string)).setBody(string3);
            storedDatabaseLogic.setAttribute("TYPE".toLowerCase(), (Object)string2);
            databaseObject.addDatabaseObject((DatabaseObject)storedDatabaseLogic);
        }
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogic) {
        return storedDatabaseLogic;
    }
}

