/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksCopyCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksEnableCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;

public abstract class AbstractChecksStateModificationCommand
extends AbstractChecksCommandStep {
    public final boolean doWork(CommandResultsBuilder resultsBuilder, String checksSettingsFile, String checkName, String autoUpdate) throws Exception {
        AbstractConfigurableRule rule;
        List<AbstractLiquibaseRule> instances = AbstractChecksStateModificationCommand.listAllRules();
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(checksSettingsFile, autoUpdate);
        CheckSettingsConfig csc = helper.read(instances);
        this.throwExceptionIfPackageFile(csc);
        if (csc == null) {
            resultsBuilder.addResult("statusCode", (Object)0);
            return false;
        }
        AbstractLiquibaseRule installedRule = null;
        List<AbstractLiquibaseRule> rules = AbstractChecksStateModificationCommand.listAllRules();
        try {
            installedRule = AbstractChecksStateModificationCommand.findRuleByShortName(rules, checkName);
            rule = csc.getRuleById(installedRule.getId());
        }
        catch (CommandExecutionException cee) {
            rule = csc.getDynamicConfigurableRuleByShortName(checkName, "does not exist. Run 'liquibase checks show' to see a list of available checks.\n");
        }
        if (installedRule != null && !installedRule.hasDefaultParameterValues() && this instanceof ChecksEnableCommandStep) {
            Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "This check can not be enabled directly because one or more fields does not have a default value.  Creating a copy of this check and initiating the customization workflow.");
            ChecksCopyCommandStep.doCopy(csc, checkName, rules, checksSettingsFile, resultsBuilder, helper);
            return false;
        }
        if (!this.validateStateModification(rule, checkName)) {
            ChecksShowCommandStep.writeTableToOutput(resultsBuilder, csc, false);
            csc.outputWarningMessage();
            resultsBuilder.addResult("statusCode", (Object)0);
            return false;
        }
        this.doStateModification(rule);
        helper.write(csc);
        Scope.getCurrentScope().getUI().sendMessage(String.format("%n%nCheck '%s' has been %s.%n", checkName, this.describeStateModification()));
        ChecksShowCommandStep.writeTableToOutput(resultsBuilder, csc, false);
        csc.outputWarningMessage();
        return true;
    }

    public abstract boolean validateStateModification(AbstractConfigurableRule var1, String var2);

    public abstract void doStateModification(AbstractConfigurableRule var1);

    public abstract String describeStateModification();
}

