/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.structured;

import com.datical.liquibase.ext.config.ExtendedLiquibaseCommandLineConfiguration;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.logging.custommdc.CustomLogDataFile;
import com.datical.liquibase.ext.util.JsonMinifyUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.logging.LogFormat;
import liquibase.logging.core.NoOpLogService;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcManager;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.resource.Resource;
import liquibase.serializer.core.yaml.YamlSerializer;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class StructuredLogFormatter
extends Formatter {
    private static final Yaml yaml;
    private static final JsonMinifyUtil minify;
    private static final MdcManager mdcManager;
    private static final AtomicBoolean filterLogMessageElementsErrorOccurred;

    @Override
    public String format(LogRecord logRecord) {
        Map<String, Object> logMessageElements = this.buildLogMessageElements(logRecord);
        List<Object> failedExcludeDataObjects = null;
        try {
            failedExcludeDataObjects = this.filterLogMessageElements(logMessageElements);
        }
        catch (Exception e) {
            this.warnAboutFailedFiltering(e);
        }
        String json = this.jsonifyLogMessage(logMessageElements);
        if (failedExcludeDataObjects != null && !failedExcludeDataObjects.isEmpty()) {
            try {
                return this.parseAndFilterJson(json, failedExcludeDataObjects);
            }
            catch (Exception e) {
                this.warnAboutFailedFiltering(e);
                return json;
            }
        }
        return json;
    }

    private void warnAboutFailedFiltering(Exception e) {
        if (!filterLogMessageElementsErrorOccurred.getAndSet(true)) {
            Scope.getCurrentScope().getUI().sendErrorMessage("Failed to filter log message elements; suppressing additional exceptions of this type.", (Throwable)e);
        }
    }

    private String parseAndFilterJson(String json, List<Object> failedExcludeMdcKeys) {
        Map parsed = (Map)yaml.load(json);
        this.filterLogMessageElements(parsed, failedExcludeMdcKeys);
        return this.jsonifyLogMessage(parsed);
    }

    private List<Object> filterLogMessageElements(Map<String, Object> logMessageElements) throws Exception {
        Resource resource;
        ConfiguredValue customLogDataFileConfig = ExtendedLiquibaseCommandLineConfiguration.CUSTOM_LOG_DATA_FILE.getCurrentConfiguredValue();
        if (customLogDataFileConfig.found() && (resource = CustomLogDataFile.getResource()).exists()) {
            ArrayList<Object> failedExcludeDataObjects = new ArrayList<Object>();
            Map<String, Object> fileContents = CustomLogDataFile.getFileContents();
            this.processCommandAgnostic(logMessageElements, failedExcludeDataObjects, fileContents);
            this.processCommandSpecific(logMessageElements, failedExcludeDataObjects, fileContents);
            return failedExcludeDataObjects;
        }
        return Collections.emptyList();
    }

    private void processCommandAgnostic(Map<String, Object> logMessageElements, List<Object> failedExcludeDataObjects, Map<String, Object> fileContents) {
        String excludeDataKey = CollectionUtil.findKeyInMapIgnoreCase((String)"liquibase.excludeData", fileContents);
        Object excludeDataObjects = fileContents.get(excludeDataKey);
        if (excludeDataObjects instanceof List) {
            failedExcludeDataObjects.addAll(this.filterLogMessageElements(logMessageElements, (List)excludeDataObjects));
        }
    }

    private void processCommandSpecific(Map<String, Object> logMessageElements, List<Object> failedExcludeDataObjects, Map<String, Object> fileContents) {
        MdcManager mdcManager = Scope.getCurrentScope().getMdcManager();
        Map mdc = mdcManager.getAll();
        String mdcCommandName = (String)mdc.get("liquibaseCommandName");
        if (StringUtil.isNotEmpty((String)mdcCommandName)) {
            try {
                for (Map.Entry<String, Object> stringObjectEntry : fileContents.entrySet()) {
                    Object excludeCommandDataObjects;
                    String key = stringObjectEntry.getKey().toLowerCase();
                    if (!key.contains("liquibase.command.")) continue;
                    String desiredCommandName = key.replace("liquibase.command.", "");
                    String[] formattedDesiredCommandName = (String[])Scope.child(Collections.singletonMap(Scope.Attr.logService.toString(), new NoOpLogService()), () -> LiquibaseCommandAction.getActualCommandName(desiredCommandName));
                    if (!formattedDesiredCommandName[0].equalsIgnoreCase(mdcCommandName) || !((excludeCommandDataObjects = stringObjectEntry.getValue()) instanceof List)) continue;
                    Map excludeCommandDataObjectsMap = (Map)((List)excludeCommandDataObjects).get(0);
                    Object excludeDataObjects = excludeCommandDataObjectsMap.get("excludeData");
                    failedExcludeDataObjects.addAll(this.filterLogMessageElements(logMessageElements, (List)excludeDataObjects));
                }
            }
            catch (Exception e) {
                this.warnAboutFailedFiltering(e);
            }
        }
    }

    private List<Object> filterLogMessageElements(Map<String, Object> logMessageElements, List<Object> excludeDataObjects) {
        ArrayList<Object> failedExcludeDataObjects = new ArrayList<Object>();
        for (Object excludeDataObject : CollectionUtil.createIfNull(excludeDataObjects)) {
            boolean removed;
            String excludeDataKey = String.valueOf(excludeDataObject);
            String foundKey = CollectionUtil.findKeyInMapIgnoreCase((String)excludeDataKey, logMessageElements);
            Object remove = logMessageElements.remove(foundKey);
            if (remove != null || (removed = StructuredLogFormatter.removeNestedValue(logMessageElements, excludeDataKey.split("\\.")))) continue;
            failedExcludeDataObjects.add(excludeDataKey);
        }
        return failedExcludeDataObjects;
    }

    private static boolean removeNestedValue(Map map, String ... keys) {
        Map value = map;
        Iterator keyIterator = Arrays.stream(keys).iterator();
        while (keyIterator.hasNext() && value instanceof Map) {
            String key = (String)keyIterator.next();
            Map value1 = value;
            String actualKey = CollectionUtil.findKeyInMapIgnoreCase((String)key, (Map)value1);
            if (!keyIterator.hasNext()) {
                return value1.remove(actualKey) != null;
            }
            value = value1.get(actualKey);
        }
        return false;
    }

    private Map<String, Object> buildLogMessageElements(LogRecord logRecord) {
        Map mdc;
        LinkedHashMap<String, Object> elements = new LinkedHashMap<String, Object>();
        elements.put("timestamp", Instant.ofEpochMilli(logRecord.getMillis()).toString());
        elements.put("level", logRecord.getLevel().getName());
        if (StringUtil.isNotEmpty((String)logRecord.getSourceClassName())) {
            elements.put("class", logRecord.getSourceClassName());
        }
        if (StringUtil.isNotEmpty((String)logRecord.getSourceMethodName())) {
            elements.put("method", logRecord.getSourceMethodName());
        }
        elements.put("thread", String.valueOf(logRecord.getThreadID()));
        String message = StringUtil.isEmpty((String)logRecord.getMessage()) ? "" : logRecord.getMessage();
        elements.put("message", message);
        if (logRecord.getThrown() != null) {
            String throwable = "";
            if (logRecord.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                logRecord.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            elements.put("exception", throwable);
        }
        if ((mdc = mdcManager.getAll()) != null) {
            for (Map.Entry mdcEntry : mdc.entrySet()) {
                Object value = mdcEntry.getValue();
                if (value == null) {
                    elements.put((String)mdcEntry.getKey(), "");
                    continue;
                }
                elements.put((String)mdcEntry.getKey(), value);
            }
        }
        return elements;
    }

    private String jsonifyLogMessage(Map<String, Object> messageElements) {
        String out = yaml.dumpAs(messageElements, Tag.MAP, DumperOptions.FlowStyle.FLOW);
        out = YamlSerializer.removeClassTypeMarksFromSerializedJson((String)out);
        out = out.replace("!!null \"null\"", "\"null\"");
        if (LiquibaseCommandLineConfiguration.LOG_FORMAT.getCurrentValue() == LogFormat.JSON_PRETTY) {
            return out;
        }
        return minify.minify(out) + System.lineSeparator();
    }

    static {
        mdcManager = Scope.getCurrentScope().getMdcManager();
        filterLogMessageElementsErrorOccurred = new AtomicBoolean(false);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setSplitLines(false);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setWidth(Integer.MAX_VALUE);
        YamlSerializer.LiquibaseRepresenter liquibaseRepresenter = new YamlSerializer.LiquibaseRepresenter(dumperOptions);
        List operators = Scope.getCurrentScope().getServiceLocator().findInstances(CustomMdcObject.class);
        for (CustomMdcObject operator : operators) {
            liquibaseRepresenter.addClassTag(operator.getClass(), Tag.MAP);
        }
        yaml = new Yaml((BaseConstructor)new SafeConstructor(YamlParser.createLoaderOptions()), (Representer)liquibaseRepresenter, dumperOptions, (Resolver)new YamlSerializer.LiquibaseResolver());
        minify = new JsonMinifyUtil();
    }
}

