/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.Fact;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.AbstractRulesEngine;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.license.pro.LicenseTier;
import liquibase.logging.Logger;

public abstract class QualityChecksRulesEngine<T>
extends AbstractRulesEngine {
    private final List<AbstractConfigurableRule> rules;
    private final List<RuleCombination> executedRules = new ArrayList<RuleCombination>();
    private final List<RuleCombination> skippedRules = new ArrayList<RuleCombination>();
    final Map<T, List<LiquibaseRuleResult>> results = new LinkedHashMap<T, List<LiquibaseRuleResult>>();

    public List<RuleCombination> getExecutedRules() {
        return this.executedRules;
    }

    public List<RuleCombination> getSkippedRules() {
        return this.skippedRules;
    }

    public Map<T, List<LiquibaseRuleResult>> getResults() {
        return this.results;
    }

    public QualityChecksRulesEngine(List<AbstractConfigurableRule> rules) {
        this.rules = rules;
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        this.doFire(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
    }

    void doFire(Rules rules, Facts facts) {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        if (rules.isEmpty()) {
            LOGGER.warning("No rules registered! Nothing to apply");
            return;
        }
        this.logEngineParameters();
        this.log(rules);
        this.log(facts);
        LOGGER.fine("Rules evaluation started");
        block4: for (Rule rule : rules) {
            LicenseTier requiredLicense;
            String name = rule.getName();
            int priority = rule.getPriority();
            if (priority > this.parameters.getPriorityThreshold()) {
                LOGGER.fine("Rule priority threshold (" + this.parameters.getPriorityThreshold() + ") exceeded at rule '" + name + "' with priority=" + priority + ", next rule will be skipped");
                break;
            }
            List<AbstractConfigurableRule> applicableInstances = this.getApplicableInstances(rule.getId());
            if (this.computeSkippedRules(rule, applicableInstances, requiredLicense = rule.getRequiredLicense(this.getScope())) || applicableInstances == null) continue;
            for (AbstractConfigurableRule ruleConfiguration : applicableInstances) {
                boolean evaluationResult;
                block10: {
                    facts.add(new Fact<AbstractConfigurableRule>(FactEnum.INSTANCE_SETTINGS.toString(), ruleConfiguration));
                    if (!this.shouldBeEvaluated(rule, facts)) {
                        LOGGER.fine("Rule '" + name + "' has been skipped before being evaluated");
                        this.processRuleResults(rule);
                        continue;
                    }
                    this.resetRuleInstance(rule);
                    evaluationResult = false;
                    try {
                        evaluationResult = rule.evaluate(facts);
                        this.executedRules.add(new RuleCombination(rule, ruleConfiguration));
                        this.processRuleResults(rule);
                    }
                    catch (Exception exception) {
                        LOGGER.severe("Rule '" + name + "' evaluated with error", (Throwable)exception);
                        Scope.getCurrentScope().getUI().sendErrorMessage("Rule '" + name + "' evaluated with error", (Throwable)exception);
                        this.triggerListenersOnEvaluationError(rule, facts, exception);
                        if (!this.parameters.isSkipOnFirstNonTriggeredRule()) break block10;
                        LOGGER.fine("Next rule will be skipped since parameter skipOnFirstNonTriggeredRule is set");
                        continue block4;
                    }
                }
                if (evaluationResult) {
                    LOGGER.fine("Rule '" + name + "' triggered");
                    this.triggerListenersAfterEvaluate(rule, facts, true);
                    try {
                        this.triggerListenersBeforeExecute(rule, facts);
                        rule.execute(facts);
                        LOGGER.fine("Rule '" + name + "' performed successfully");
                        this.triggerListenersOnSuccess(rule, facts);
                        if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                        LOGGER.fine("Next rule will be skipped since parameter skipOnFirstAppliedRule is set");
                    }
                    catch (Exception exception) {
                        LOGGER.severe("Rule '" + name + "' performed with error", (Throwable)exception);
                        this.triggerListenersOnFailure(rule, exception, facts);
                        if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                        LOGGER.fine("Next rule will be skipped since parameter skipOnFirstFailedRule is set");
                    }
                    continue block4;
                }
                LOGGER.fine("Rule '" + name + "' has been evaluated to false, it has not been executed");
                this.triggerListenersAfterEvaluate(rule, facts, false);
                if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
                LOGGER.fine("Next rule will be skipped since parameter skipOnFirstNonTriggeredRule is set");
                continue block4;
            }
        }
    }

    private void resetRuleInstance(Rule rule) {
        if (rule instanceof AbstractLiquibaseRule) {
            rule.getResults().clear();
            rule.getDatabaseResults().clear();
        }
    }

    private boolean computeSkippedRules(Rule rule, List<AbstractConfigurableRule> applicableInstances, LicenseTier requiredLicense) {
        if (requiredLicense != null && !requiredLicense.isValid() && rule.getScope().contains((Object)this.getScope())) {
            for (AbstractConfigurableRule applicableInstance : applicableInstances) {
                this.skippedRules.add(new RuleCombination(rule, applicableInstance));
            }
            return true;
        }
        return false;
    }

    private void processRuleResults(Rule rule) {
        Map<T, LiquibaseRuleResult> ruleResult = this.getRuleResults(rule);
        for (Map.Entry<T, LiquibaseRuleResult> changeSetLiquibaseRuleResultEntry : ruleResult.entrySet()) {
            if (this.results.containsKey(changeSetLiquibaseRuleResultEntry.getKey())) {
                this.results.get(changeSetLiquibaseRuleResultEntry.getKey()).add(changeSetLiquibaseRuleResultEntry.getValue());
                continue;
            }
            this.results.put(changeSetLiquibaseRuleResultEntry.getKey(), new ArrayList<LiquibaseRuleResult>(Collections.singletonList(changeSetLiquibaseRuleResultEntry.getValue())));
        }
    }

    public abstract Map<T, LiquibaseRuleResult> getRuleResults(Rule var1);

    public abstract ScopeEnum getScope();

    public List<AbstractConfigurableRule> getApplicableInstances(UUID executingRuleId) {
        return this.rules.stream().filter(r -> this.ruleMatches((AbstractConfigurableRule)r, executingRuleId)).collect(Collectors.toList());
    }

    private boolean ruleMatches(AbstractConfigurableRule rule, UUID executingRuleId) {
        boolean idEquals = rule instanceof DynamicRule ? executingRuleId.equals(rule.getId()) || ((DynamicRule)rule).getParentRuleId() != null && ((DynamicRule)rule).getParentRuleId().equals(executingRuleId) : executingRuleId.equals(rule.getId());
        return rule.isEnabled() && idEquals;
    }

    private void logEngineParameters() {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        LOGGER.fine(this.parameters.toString());
    }

    private void log(Rules rules) {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        LOGGER.fine("Registered rules:");
        for (Rule rule : rules) {
            LOGGER.fine("Rule { name = '" + rule.getName() + "', description = '" + rule.getDescription() + "', priority = '" + rule.getPriority() + "'}");
        }
    }

    private void log(Facts facts) {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        LOGGER.fine("Known facts:");
        for (Fact<?> fact : facts) {
            LOGGER.fine(fact.toString());
        }
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) throws Exception {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        Map<Rule, Boolean> result = this.doCheck(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
        return result;
    }

    private Map<Rule, Boolean> doCheck(Rules rules, Facts facts) throws Exception {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        LOGGER.fine("Checking rules");
        HashMap<Rule, Boolean> result = new HashMap<Rule, Boolean>();
        for (Rule rule : rules) {
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            result.put(rule, rule.evaluate(facts));
        }
        return result;
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onFailure(rule, facts, exception));
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onSuccess(rule, facts));
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.beforeExecute(rule, facts));
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        return this.ruleListeners.stream().allMatch(ruleListener -> ruleListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.afterEvaluate(rule, facts, evaluationResult));
    }

    private void triggerListenersOnEvaluationError(Rule rule, Facts facts, Exception exception) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onEvaluationError(rule, facts, exception));
    }

    private void triggerListenersBeforeRules(Rules rule, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersAfterRules(Rules rule, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.afterExecute(rule, facts));
    }

    public boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }
}

