/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import liquibase.repackaged.net.sf.jsqlparser.expression.MySQLIndexHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.SQLServerHints;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowDefinition;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Fetch;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.First;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralSubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralView;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Offset;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OptimizeFor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Pivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotXml;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Skip;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.TableFunction;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Top;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnPivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Values;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.GroupByDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.LimitDeparser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.OrderByDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ValuesStatementDeParser;

public class SelectDeParser
extends AbstractDeParser<PlainSelect>
implements SelectVisitor,
SelectItemVisitor,
FromItemVisitor,
PivotVisitor {
    private ExpressionVisitor expressionVisitor;

    public SelectDeParser() {
        this(new StringBuilder());
    }

    public SelectDeParser(StringBuilder buffer) {
        this(new ExpressionVisitorAdapter(), buffer);
    }

    public SelectDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(ParenthesedSelect selectBody) {
        UnPivot unpivot;
        Pivot pivot;
        Alias alias;
        List<WithItem> withItemsList = selectBody.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            for (WithItem withItem : withItemsList) {
                withItem.accept(this);
                this.buffer.append(" ");
            }
        }
        this.buffer.append("(");
        selectBody.getSelect().accept(this);
        this.buffer.append(")");
        if (selectBody.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(selectBody.isOracleSiblings(), selectBody.getOrderByElements());
        }
        if ((alias = selectBody.getAlias()) != null) {
            this.buffer.append(alias);
        }
        if ((pivot = selectBody.getPivot()) != null) {
            pivot.accept(this);
        }
        if ((unpivot = selectBody.getUnPivot()) != null) {
            unpivot.accept(this);
        }
        if (selectBody.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(selectBody.getLimit());
        }
        if (selectBody.getOffset() != null) {
            this.visit(selectBody.getOffset());
        }
        if (selectBody.getFetch() != null) {
            this.visit(selectBody.getFetch());
        }
        if (selectBody.getIsolation() != null) {
            this.buffer.append(selectBody.getIsolation().toString());
        }
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        Iterator<ASTNodeAccessImpl> iter;
        List<SelectItem<?>> selectItems;
        Top top;
        First first;
        Skip skip;
        OracleHint hint;
        List<WithItem> withItemsList = plainSelect.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter2 = withItemsList.iterator();
            while (iter2.hasNext()) {
                iter2.next().accept(this);
                if (iter2.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("SELECT ");
        if (plainSelect.getMySqlHintStraightJoin()) {
            this.buffer.append("STRAIGHT_JOIN ");
        }
        if ((hint = plainSelect.getOracleHint()) != null) {
            this.buffer.append(hint).append(" ");
        }
        if ((skip = plainSelect.getSkip()) != null) {
            this.buffer.append(skip).append(" ");
        }
        if ((first = plainSelect.getFirst()) != null) {
            this.buffer.append(first).append(" ");
        }
        if (plainSelect.getDistinct() != null) {
            if (plainSelect.getDistinct().isUseUnique()) {
                this.buffer.append("UNIQUE ");
            } else {
                this.buffer.append("DISTINCT ");
            }
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.buffer.append("ON (");
                Iterator<SelectItem<?>> iter3 = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (iter3.hasNext()) {
                    SelectItem<?> selectItem = iter3.next();
                    selectItem.accept(this);
                    if (!iter3.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
        if ((top = plainSelect.getTop()) != null) {
            this.buffer.append(top).append(" ");
        }
        if (plainSelect.getMySqlSqlCacheFlag() != null) {
            this.buffer.append(plainSelect.getMySqlSqlCacheFlag().name()).append(" ");
        }
        if (plainSelect.getMySqlSqlCalcFoundRows()) {
            this.buffer.append("SQL_CALC_FOUND_ROWS").append(" ");
        }
        if ((selectItems = plainSelect.getSelectItems()) != null) {
            iter = selectItems.iterator();
            while (iter.hasNext()) {
                SelectItem<?> selectItem = iter.next();
                selectItem.accept(this);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getIntoTables() != null) {
            this.buffer.append(" INTO ");
            iter = plainSelect.getIntoTables().iterator();
            while (iter.hasNext()) {
                this.visit((Table)iter.next());
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            Table table;
            this.buffer.append(" FROM ");
            plainSelect.getFromItem().accept(this);
            if (plainSelect.getFromItem() instanceof Table && (table = (Table)plainSelect.getFromItem()).getSampleClause() != null) {
                table.getSampleClause().appendTo(this.buffer);
            }
        }
        if (plainSelect.getLateralViews() != null) {
            for (LateralView lateralView : plainSelect.getLateralViews()) {
                this.deparseLateralView(lateralView);
            }
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.isUsingFinal()) {
            this.buffer.append(" FINAL");
        }
        if (plainSelect.getKsqlWindow() != null) {
            this.buffer.append(" WINDOW ");
            this.buffer.append(plainSelect.getKsqlWindow().toString());
        }
        if (plainSelect.getWhere() != null) {
            this.buffer.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupBy() != null) {
            this.buffer.append(" ");
            new GroupByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.getGroupBy());
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getQualify() != null) {
            this.buffer.append(" QUALIFY ");
            plainSelect.getQualify().accept(this.expressionVisitor);
        }
        if (plainSelect.getWindowDefinitions() != null) {
            this.buffer.append(" WINDOW ");
            this.buffer.append(plainSelect.getWindowDefinitions().stream().map(WindowDefinition::toString).collect(Collectors.joining(", ")));
        }
        if (plainSelect.isForUpdate()) {
            this.buffer.append(" FOR UPDATE");
            if (plainSelect.getForUpdateTable() != null) {
                this.buffer.append(" OF ").append(plainSelect.getForUpdateTable());
            }
            if (plainSelect.getWait() != null) {
                this.buffer.append(plainSelect.getWait());
            }
            if (plainSelect.isNoWait()) {
                this.buffer.append(" NOWAIT");
            } else if (plainSelect.isSkipLocked()) {
                this.buffer.append(" SKIP LOCKED");
            }
        }
        if (plainSelect.getForClause() != null) {
            plainSelect.getForClause().appendTo(this.buffer);
        }
        if (plainSelect.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.isEmitChanges()) {
            this.buffer.append(" EMIT CHANGES");
        }
        if (plainSelect.getLimitBy() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(plainSelect.getLimitBy());
        }
        if (plainSelect.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.visit(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.visit(plainSelect.getFetch());
        }
        if (plainSelect.getIsolation() != null) {
            this.buffer.append(plainSelect.getIsolation().toString());
        }
        if (plainSelect.getOptimizeFor() != null) {
            this.deparseOptimizeFor(plainSelect.getOptimizeFor());
        }
        if (plainSelect.getForXmlPath() != null) {
            this.buffer.append(" FOR XML PATH(").append(plainSelect.getForXmlPath()).append(")");
        }
    }

    @Override
    public void visit(SelectItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.expressionVisitor);
        if (selectExpressionItem.getAlias() != null) {
            this.buffer.append(selectExpressionItem.getAlias().toString());
        }
    }

    @Override
    public void visit(Table tableName) {
        SQLServerHints sqlServerHints;
        MySQLIndexHint indexHint;
        UnPivot unpivot;
        Pivot pivot;
        this.buffer.append(tableName.getFullyQualifiedName());
        Alias alias = tableName.getAlias();
        if (alias != null) {
            this.buffer.append(alias);
        }
        if ((pivot = tableName.getPivot()) != null) {
            pivot.accept(this);
        }
        if ((unpivot = tableName.getUnPivot()) != null) {
            unpivot.accept(this);
        }
        if ((indexHint = tableName.getIndexHint()) != null) {
            this.buffer.append(indexHint);
        }
        if ((sqlServerHints = tableName.getSqlServerHints()) != null) {
            this.buffer.append(sqlServerHints);
        }
    }

    @Override
    public void visit(Pivot pivot) {
        this.buffer.append(" PIVOT (").append(PlainSelect.getStringList(pivot.getFunctionItems()));
        this.buffer.append(" FOR ");
        pivot.getForColumns().accept(this.expressionVisitor);
        this.buffer.append(" IN ").append(PlainSelect.getStringList(pivot.getInItems(), true, true));
        this.buffer.append(")");
        if (pivot.getAlias() != null) {
            this.buffer.append(pivot.getAlias().toString());
        }
    }

    @Override
    public void visit(UnPivot unpivot) {
        boolean showOptions = unpivot.getIncludeNullsSpecified();
        boolean includeNulls = unpivot.getIncludeNulls();
        List<Column> unPivotClause = unpivot.getUnPivotClause();
        List<Column> unpivotForClause = unpivot.getUnPivotForClause();
        this.buffer.append(" UNPIVOT").append(showOptions && includeNulls ? " INCLUDE NULLS" : "").append(showOptions && !includeNulls ? " EXCLUDE NULLS" : "").append(" (").append(PlainSelect.getStringList(unPivotClause, true, unPivotClause != null && unPivotClause.size() > 1)).append(" FOR ").append(PlainSelect.getStringList(unpivotForClause, true, unpivotForClause != null && unpivotForClause.size() > 1)).append(" IN ").append(PlainSelect.getStringList(unpivot.getUnPivotInClause(), true, true)).append(")");
        if (unpivot.getAlias() != null) {
            this.buffer.append(unpivot.getAlias().toString());
        }
    }

    @Override
    public void visit(PivotXml pivot) {
        ExpressionList<Column> forColumns = pivot.getForColumns();
        this.buffer.append(" PIVOT XML (").append(PlainSelect.getStringList(pivot.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(forColumns, true, forColumns != null && forColumns.size() > 1)).append(" IN (");
        if (pivot.isInAny()) {
            this.buffer.append("ANY");
        } else if (pivot.getInSelect() != null) {
            this.buffer.append(pivot.getInSelect());
        } else {
            this.buffer.append(PlainSelect.getStringList(pivot.getInItems()));
        }
        this.buffer.append("))");
    }

    public void visit(Offset offset) {
        this.buffer.append(" OFFSET ");
        offset.getOffset().accept(this.expressionVisitor);
        if (offset.getOffsetParam() != null) {
            this.buffer.append(" ").append(offset.getOffsetParam());
        }
    }

    public void visit(Fetch fetch) {
        this.buffer.append(" FETCH ");
        if (fetch.isFetchParamFirst()) {
            this.buffer.append("FIRST ");
        } else {
            this.buffer.append("NEXT ");
        }
        fetch.getExpression().accept(this.expressionVisitor);
        this.buffer.append(" ").append(fetch.getFetchParam()).append(" ONLY");
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void deparseJoin(Join join) {
        if (join.isGlobal()) {
            this.buffer.append(" GLOBAL ");
        }
        if (join.isSimple() && join.isOuter()) {
            this.buffer.append(", OUTER ");
        } else if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            if (join.isNatural()) {
                this.buffer.append(" NATURAL");
            }
            if (join.isRight()) {
                this.buffer.append(" RIGHT");
            } else if (join.isFull()) {
                this.buffer.append(" FULL");
            } else if (join.isLeft()) {
                this.buffer.append(" LEFT");
            } else if (join.isCross()) {
                this.buffer.append(" CROSS");
            }
            if (join.isOuter()) {
                this.buffer.append(" OUTER");
            } else if (join.isInner()) {
                this.buffer.append(" INNER");
            } else if (join.isSemi()) {
                this.buffer.append(" SEMI");
            }
            if (join.isStraight()) {
                this.buffer.append(" STRAIGHT_JOIN ");
            } else if (join.isApply()) {
                this.buffer.append(" APPLY ");
            } else {
                this.buffer.append(" JOIN ");
            }
        }
        FromItem fromItem = join.getFromItem();
        fromItem.accept(this);
        if (join.isWindowJoin()) {
            this.buffer.append(" WITHIN ");
            this.buffer.append(join.getJoinWindow().toString());
        }
        for (Expression onExpression : join.getOnExpressions()) {
            this.buffer.append(" ON ");
            onExpression.accept(this.expressionVisitor);
        }
        if (join.getUsingColumns().size() > 0) {
            this.buffer.append(" USING (");
            Iterator<Column> iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = iterator.next();
                this.buffer.append(column.toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
    }

    public void deparseLateralView(LateralView lateralView) {
        this.buffer.append(" LATERAL VIEW");
        if (lateralView.isUsingOuter()) {
            this.buffer.append(" OUTER");
        }
        this.buffer.append(" ");
        lateralView.getGeneratorFunction().accept(this.expressionVisitor);
        if (lateralView.getTableAlias() != null) {
            this.buffer.append(" ").append(lateralView.getTableAlias());
        }
        this.buffer.append(" ").append(lateralView.getColumnAlias());
    }

    @Override
    public void visit(SetOperationList list) {
        List<WithItem> withItemsList = list.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        for (int i = 0; i < list.getSelects().size(); ++i) {
            if (i != 0) {
                this.buffer.append(' ').append(list.getOperations().get(i - 1)).append(' ');
            }
            list.getSelects().get(i).accept(this);
        }
        if (list.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(list.getOrderByElements());
        }
        if (list.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(list.getLimit());
        }
        if (list.getOffset() != null) {
            this.visit(list.getOffset());
        }
        if (list.getFetch() != null) {
            this.visit(list.getFetch());
        }
        if (list.getIsolation() != null) {
            this.buffer.append(list.getIsolation().toString());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        if (withItem.isRecursive()) {
            this.buffer.append("RECURSIVE ");
        }
        this.buffer.append(withItem.getAlias().getName());
        if (withItem.getWithItemList() != null) {
            this.buffer.append(" ").append(PlainSelect.getStringList(withItem.getWithItemList(), true, true));
        }
        this.buffer.append(" AS ");
        withItem.getSelect().accept(this);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.buffer.append(lateralSubSelect.getPrefix());
        this.visit((ParenthesedSelect)lateralSubSelect);
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.buffer.append(tableFunction.toString());
    }

    @Override
    public void visit(ParenthesedFromItem fromItem) {
        this.buffer.append("(");
        fromItem.getFromItem().accept(this);
        List<Join> joins = fromItem.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        this.buffer.append(")");
        if (fromItem.getAlias() != null) {
            this.buffer.append(fromItem.getAlias().toString());
        }
        if (fromItem.getPivot() != null) {
            this.visit(fromItem.getPivot());
        }
        if (fromItem.getUnPivot() != null) {
            this.visit(fromItem.getUnPivot());
        }
    }

    @Override
    public void visit(Values values) {
        new ValuesStatementDeParser(this.expressionVisitor, this.buffer).deParse(values);
    }

    private void deparseOptimizeFor(OptimizeFor optimizeFor) {
        this.buffer.append(" OPTIMIZE FOR ");
        this.buffer.append(optimizeFor.getRowCount());
        this.buffer.append(" ROWS");
    }

    @Override
    void deParse(PlainSelect statement) {
        statement.accept(this);
    }
}

