/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.util;

import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.util.BaseMessage;
import net.java.truelicense.core.util.FormattedResourceBundle;
import net.java.truelicense.core.util.Objects;

@Immutable
public class FormattedMessage
extends BaseMessage {
    private static final long serialVersionUID = 0L;
    private final String baseName;
    private final String key;
    private final Object[] args;

    public FormattedMessage(Class<?> clazz, String string, Object ... objectArray) {
        this(clazz.getName(), string, objectArray);
    }

    @Deprecated
    protected FormattedMessage(String string, Object ... objectArray) {
        this((String)null, string, objectArray);
    }

    private FormattedMessage(@CheckForNull String string, String string2, Object ... objectArray) {
        this.baseName = string;
        this.key = Objects.requireNonNull(string2);
        this.args = (Object[])objectArray.clone();
    }

    protected String baseName() {
        return this.baseName;
    }

    @Override
    public String toString(Locale locale) {
        FormattedResourceBundle formattedResourceBundle = this.bundle(locale);
        return 0 == this.args.length ? formattedResourceBundle.lookup(this.key) : formattedResourceBundle.format(this.key, this.args);
    }

    private FormattedResourceBundle bundle(Locale locale) {
        return FormattedResourceBundle.bundle(this.baseName(), locale);
    }
}

