/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymChange;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;

public class UnexpectedSynonymChangeGenerator
extends LicenseCheckingChangeGenerator
implements UnexpectedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Synonym.class.isAssignableFrom(objectType)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Synonym synonym = (Synonym)unexpectedObject;
        if (!synonym.isPrivate() && !((Boolean)LiquibaseProConfiguration.DROP_PUBLIC_SYNONYMS_KEY.getCurrentValue()).booleanValue()) {
            return null;
        }
        DropSynonymChange change = new DropSynonymChange();
        change.setSynonymName(synonym.getName());
        if (!(comparisonDatabase instanceof MSSQLDatabase)) {
            change.setPrivate(synonym.isPrivate());
        }
        change.setObjectType(synonym.getObjectType());
        if (control.getIncludeCatalog()) {
            change.setSynonymCatalogName(synonym.getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSynonymSchemaName(synonym.getSchema().getName());
        }
        return new Change[]{change};
    }
}

