/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import liquibase.util.StringUtil;

public class StringListGetter
extends AbstractCommandLineValueGetter<String> {
    private final Set<String> validOptions;

    public StringListGetter() {
        this((Set<String>)null);
    }

    public StringListGetter(Set<String> validOptions) {
        super(String.class);
        this.validOptions = validOptions;
    }

    @Override
    public boolean validate(String input) {
        return StringListGetter.validate(input, this.validOptions, "is not a valid word.");
    }

    @Override
    public String convert(String input) {
        return input.toUpperCase();
    }

    public static boolean validate(String input, Set<String> validOptions, String errorMessage) {
        if (validOptions != null) {
            List<String> splits = StringListGetter.split(input);
            for (String split : splits) {
                String upper = split.toUpperCase();
                if (validOptions.contains(upper)) continue;
                throw new IllegalArgumentException(split + " " + errorMessage.trim());
            }
        }
        return true;
    }

    public static List<String> split(String input) {
        if (StringUtil.isEmpty((String)input)) {
            return Collections.emptyList();
        }
        return StringUtil.splitAndTrim((String)input, (String)",");
    }

    @Override
    public String describe() {
        if (this.validOptions == null || this.validOptions.isEmpty()) {
            return "comma-separated list";
        }
        return "comma-separated list; valid values: " + StringUtil.join(this.validOptions, (String)", ");
    }
}

