/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.ChangesetAttributes;
import com.datical.liquibase.ext.checks.dynamic.AbstractChangesetAttributesRule;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ChangesetAttributesSetTrueOrFalse
extends AbstractChangesetAttributesRule {
    @Override
    protected boolean equalityCheck(String changesetAttribute, String searchString) {
        return changesetAttribute.equals(searchString);
    }

    @Override
    protected String getFailureMessage(List<ChangesetAttributes> wrongAttributes, String searchString) {
        String pluralizedAttributes = wrongAttributes.size() > 1 ? "attributes" : "attribute";
        String isAre = wrongAttributes.size() > 1 ? "are" : "is";
        return "The " + pluralizedAttributes + " '" + StringUtils.join(wrongAttributes, (String)", ") + "' " + isAre + " set to " + !Boolean.parseBoolean(searchString) + ", but should be set to " + searchString + ".";
    }

    @Override
    public String getShortName() {
        return "ChangesetAttributesSetTrueOrFalse";
    }

    @Override
    public Class<?> getPermittedType() {
        return Boolean.class;
    }

    @Override
    public String getDescription() {
        return "This check triggers when specified attributes do not match TRUE or FALSE, as configured by the user.";
    }

    @Override
    public boolean allowMultipleAttributes() {
        return true;
    }

    @Override
    public int getPriority() {
        return 505;
    }
}

