/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class LiquibaseQualityCheckResult {
    private final List<LiquibaseRuleResult> ruleResults;
    private final List<AbstractConfigurableRule> configurableRules;
    private final List<String> ruleNamesSkippedDueToUnparseableSql;
    private final List<RuleCombination> executedRules;
    private final List<LiquibaseRuleResult> invalidChangelogFileTypeFailures;
    private final List<LiquibaseRuleResult> rulesSkippedDueToUnparseableSql;

    public LiquibaseQualityCheckResult(List<LiquibaseRuleResult> ruleResults, List<AbstractConfigurableRule> configurableRules, List<LiquibaseRuleResult> rulesSkippedDueToUnparseableSql, List<String> ruleNamesSkippedDueToUnparseableSql, @Nullable List<RuleCombination> executedRules, @Nullable List<LiquibaseRuleResult> invalidChangelogFileTypeFailures) {
        this.ruleResults = ruleResults;
        this.configurableRules = configurableRules;
        this.rulesSkippedDueToUnparseableSql = rulesSkippedDueToUnparseableSql;
        this.ruleNamesSkippedDueToUnparseableSql = ruleNamesSkippedDueToUnparseableSql;
        this.executedRules = executedRules == null ? new ArrayList() : executedRules;
        this.invalidChangelogFileTypeFailures = invalidChangelogFileTypeFailures == null ? new ArrayList() : invalidChangelogFileTypeFailures;
    }

    public List<LiquibaseRuleResult> getRuleResults() {
        return Collections.unmodifiableList(this.ruleResults);
    }

    public void addResults(List<LiquibaseRuleResult> results) {
        if (results != null) {
            this.ruleResults.addAll(results);
        }
    }

    public void addExecutedRules(List<RuleCombination> executedRulesToAdd) {
        this.executedRules.addAll(executedRulesToAdd);
    }

    public List<LiquibaseRuleResult> getRulesSkippedDueToUnparseableSql() {
        return this.rulesSkippedDueToUnparseableSql;
    }

    public List<String> getRuleNamesSkippedDueToUnparseableSql() {
        return Collections.unmodifiableList(this.ruleNamesSkippedDueToUnparseableSql);
    }

    public List<AbstractConfigurableRule> getConfigurableRules() {
        return this.configurableRules;
    }

    public List<RuleCombination> getExecutedRules() {
        return Collections.unmodifiableList(this.executedRules);
    }

    public List<RuleCombination> getExecutedRules(String checkSettingsConfigFilename) {
        ArrayList<RuleCombination> filteredRules = new ArrayList<RuleCombination>();
        for (RuleCombination executedRule : this.executedRules) {
            AbstractConfigurableRule configurableRule = executedRule.configurableRule;
            if (!configurableRule.checkSettingsConfigFilenameMatches(checkSettingsConfigFilename)) continue;
            filteredRules.add(executedRule);
        }
        return Collections.unmodifiableList(filteredRules);
    }

    public List<LiquibaseRuleResult> getInvalidChangesetFileTypeFailures() {
        return this.invalidChangelogFileTypeFailures;
    }
}

