/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.rules.annotation.Action;
import com.datical.liquibase.ext.rules.annotation.Condition;
import com.datical.liquibase.ext.rules.annotation.Fact;
import com.datical.liquibase.ext.rules.annotation.Priority;
import com.datical.liquibase.ext.rules.annotation.Rule;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.ActionMethodOrderBean;
import com.datical.liquibase.ext.rules.core.NoSuchFactException;
import com.datical.liquibase.ext.rules.core.RuleDefinitionValidator;
import com.datical.liquibase.ext.rules.core.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.logging.Logger;

public class RuleProxy
implements InvocationHandler {
    private final Object target;
    private String name;
    private String description;
    private Integer priority;
    private Method[] methods;
    private Method conditionMethod;
    private Set<ActionMethodOrderBean> actionMethods;
    private Method compareToMethod;
    private Method toStringMethod;
    private Rule annotation;
    private static final RuleDefinitionValidator ruleDefinitionValidator = new RuleDefinitionValidator();

    public static com.datical.liquibase.ext.rules.api.Rule asRule(Object rule) {
        com.datical.liquibase.ext.rules.api.Rule result;
        if (rule instanceof com.datical.liquibase.ext.rules.api.Rule) {
            result = (com.datical.liquibase.ext.rules.api.Rule)rule;
        } else {
            ruleDefinitionValidator.validateRuleDefinition(rule);
            result = (com.datical.liquibase.ext.rules.api.Rule)Proxy.newProxyInstance(com.datical.liquibase.ext.rules.api.Rule.class.getClassLoader(), new Class[]{com.datical.liquibase.ext.rules.api.Rule.class, Comparable.class}, (InvocationHandler)new RuleProxy(rule));
        }
        return result;
    }

    private RuleProxy(Object target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getName": {
                return this.getRuleName();
            }
            case "getDescription": {
                return this.getRuleDescription();
            }
            case "getPriority": {
                return this.getRulePriority();
            }
            case "compareTo": {
                return this.compareToMethod(args);
            }
            case "evaluate": {
                return this.evaluateMethod(args);
            }
            case "execute": {
                return this.executeMethod(args);
            }
            case "equals": {
                return this.equalsMethod(args);
            }
            case "hashCode": {
                return this.hashCodeMethod();
            }
            case "toString": {
                return this.toStringMethod();
            }
        }
        return null;
    }

    private Object evaluateMethod(Object[] args) throws IllegalAccessException, InvocationTargetException {
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        Facts facts = (Facts)args[0];
        Method conditionMethod = this.getConditionMethod();
        try {
            List<Object> actualParameters = this.getActualParameters(conditionMethod, facts);
            return conditionMethod.invoke(this.target, actualParameters.toArray());
        }
        catch (NoSuchFactException e) {
            LOGGER.warning("Rule '" + this.getTargetClass().getName() + "' has been evaluated to false due to a declared but missing fact '" + e.getMissingFact() + "' in " + facts, (Throwable)e);
            return false;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("Types of injected facts in method '" + conditionMethod.getName() + "' in rule '" + this.getTargetClass().getName() + "' do not match parameters types", (Throwable)e);
            return false;
        }
    }

    private Object executeMethod(Object[] args) throws IllegalAccessException, InvocationTargetException {
        Facts facts = (Facts)args[0];
        for (ActionMethodOrderBean actionMethodBean : this.getActionMethodBeans()) {
            Method actionMethod = actionMethodBean.getMethod();
            List<Object> actualParameters = this.getActualParameters(actionMethod, facts);
            actionMethod.invoke(this.target, actualParameters.toArray());
        }
        return null;
    }

    private Object compareToMethod(Object[] args) throws Exception {
        Method compareToMethod = this.getCompareToMethod();
        Object otherRule = args[0];
        if (compareToMethod != null && Proxy.isProxyClass(otherRule.getClass())) {
            if (compareToMethod.getParameters().length != 1) {
                throw new IllegalArgumentException("compareTo method must have a single argument");
            }
            RuleProxy ruleProxy = (RuleProxy)Proxy.getInvocationHandler(otherRule);
            return compareToMethod.invoke(this.target, ruleProxy.getTarget());
        }
        return this.compareTo((com.datical.liquibase.ext.rules.api.Rule)otherRule);
    }

    private List<Object> getActualParameters(Method method, Facts facts) {
        Annotation[][] parameterAnnotations;
        ArrayList<Object> actualParameters = new ArrayList<Object>();
        for (Annotation[] annotations : parameterAnnotations = method.getParameterAnnotations()) {
            if (annotations.length == 1) {
                String factName = ((Fact)annotations[0]).value();
                Object fact = facts.get(factName);
                if (fact == null && !facts.asMap().containsKey(factName)) {
                    throw new NoSuchFactException(String.format("No fact named '%s' found in known facts: %n%s", factName, facts), factName);
                }
                actualParameters.add(fact);
                continue;
            }
            actualParameters.add(facts);
        }
        return actualParameters;
    }

    private boolean equalsMethod(Object[] args) throws Exception {
        if (!(args[0] instanceof com.datical.liquibase.ext.rules.api.Rule)) {
            return false;
        }
        com.datical.liquibase.ext.rules.api.Rule otherRule = (com.datical.liquibase.ext.rules.api.Rule)args[0];
        int otherPriority = otherRule.getPriority();
        int priority = this.getRulePriority();
        if (priority != otherPriority) {
            return false;
        }
        String otherName = otherRule.getName();
        String name = this.getRuleName();
        if (!name.equals(otherName)) {
            return false;
        }
        String otherDescription = otherRule.getDescription();
        String description = this.getRuleDescription();
        return Objects.equals(description, otherDescription);
    }

    private int hashCodeMethod() throws Exception {
        int result = this.getRuleName().hashCode();
        int priority = this.getRulePriority();
        String description = this.getRuleDescription();
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + priority;
        return result;
    }

    private Method getToStringMethod() {
        if (this.toStringMethod == null) {
            Method[] methods;
            for (Method method : methods = this.getMethods()) {
                if (!"toString".equals(method.getName())) continue;
                this.toStringMethod = method;
                return this.toStringMethod;
            }
        }
        return this.toStringMethod;
    }

    private String toStringMethod() throws Exception {
        Method toStringMethod = this.getToStringMethod();
        if (toStringMethod != null) {
            return (String)toStringMethod.invoke(this.target, new Object[0]);
        }
        return this.getRuleName();
    }

    private int compareTo(com.datical.liquibase.ext.rules.api.Rule otherRule) throws Exception {
        int otherPriority = otherRule.getPriority();
        int priority = this.getRulePriority();
        if (priority < otherPriority) {
            return -1;
        }
        if (priority > otherPriority) {
            return 1;
        }
        String otherName = otherRule.getName();
        String name = this.getRuleName();
        return name.compareTo(otherName);
    }

    private int getRulePriority() throws Exception {
        if (this.priority == null) {
            Method[] methods;
            int priority = 0x7FFFFFFE;
            Rule rule = this.getRuleAnnotation();
            if (rule.priority() != 0x7FFFFFFE) {
                priority = rule.priority();
            }
            for (Method method : methods = this.getMethods()) {
                if (!method.isAnnotationPresent(Priority.class)) continue;
                priority = (Integer)method.invoke(this.target, new Object[0]);
                break;
            }
            this.priority = priority;
        }
        return this.priority;
    }

    private Method getConditionMethod() {
        if (this.conditionMethod == null) {
            Method[] methods;
            for (Method method : methods = this.getMethods()) {
                if (!method.isAnnotationPresent(Condition.class)) continue;
                this.conditionMethod = method;
                return this.conditionMethod;
            }
        }
        return this.conditionMethod;
    }

    private Set<ActionMethodOrderBean> getActionMethodBeans() {
        if (this.actionMethods == null) {
            Method[] methods;
            this.actionMethods = new TreeSet<ActionMethodOrderBean>();
            for (Method method : methods = this.getMethods()) {
                if (!method.isAnnotationPresent(Action.class)) continue;
                Action actionAnnotation = method.getAnnotation(Action.class);
                int order = actionAnnotation.order();
                this.actionMethods.add(new ActionMethodOrderBean(method, order));
            }
        }
        return this.actionMethods;
    }

    private Method getCompareToMethod() {
        if (this.compareToMethod == null) {
            Method[] methods;
            for (Method method : methods = this.getMethods()) {
                if (!method.getName().equals("compareTo")) continue;
                this.compareToMethod = method;
                return this.compareToMethod;
            }
        }
        return this.compareToMethod;
    }

    private Method[] getMethods() {
        if (this.methods == null) {
            this.methods = this.getTargetClass().getMethods();
        }
        return this.methods;
    }

    private Rule getRuleAnnotation() {
        if (this.annotation == null) {
            this.annotation = Utils.findAnnotation(Rule.class, this.getTargetClass());
        }
        return this.annotation;
    }

    private String getRuleName() {
        if (this.name == null) {
            Rule rule = this.getRuleAnnotation();
            this.name = rule.name().equals("rule") ? this.getTargetClass().getSimpleName() : rule.name();
        }
        return this.name;
    }

    private String getRuleDescription() {
        if (this.description == null) {
            StringBuilder description = new StringBuilder();
            this.appendConditionMethodName(description);
            this.appendActionMethodsNames(description);
            Rule rule = this.getRuleAnnotation();
            this.description = rule.description().equals("description") ? description.toString() : rule.description();
        }
        return this.description;
    }

    private void appendConditionMethodName(StringBuilder description) {
        Method method = this.getConditionMethod();
        if (method != null) {
            description.append("when ");
            description.append(method.getName());
            description.append(" then ");
        }
    }

    private void appendActionMethodsNames(StringBuilder description) {
        Iterator<ActionMethodOrderBean> iterator = this.getActionMethodBeans().iterator();
        while (iterator.hasNext()) {
            description.append(iterator.next().getMethod().getName());
            if (!iterator.hasNext()) continue;
            description.append(",");
        }
    }

    public Object getTarget() {
        return this.target;
    }

    private Class<?> getTargetClass() {
        return this.target.getClass();
    }
}

