/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import com.datical.liquibase.ext.sqlgenerator.DatabaseChangeLogHistoryColumns;
import com.datical.liquibase.ext.statement.CreateDatabaseChangeLogHistoryTableStatement;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.TempObjectQuotingStrategy;
import liquibase.database.core.MSSQLDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateTableStatement;

public class CreateDatabaseChangeLogHistoryTableGenerator
extends AbstractSqlGenerator<CreateDatabaseChangeLogHistoryTableStatement> {
    public static final int varchar255Size = 255;
    public static final int varchar2500size = 2500;

    public ValidationErrors validate(CreateDatabaseChangeLogHistoryTableStatement statement, Database database, SqlGeneratorChain<CreateDatabaseChangeLogHistoryTableStatement> sqlGeneratorChain) {
        return new ValidationErrors();
    }

    public Sql[] generateSql(CreateDatabaseChangeLogHistoryTableStatement statement, Database database, SqlGeneratorChain<CreateDatabaseChangeLogHistoryTableStatement> sqlGeneratorChain) {
        String charTypeName = this.getCharTypeName(database);
        String dateTimeTypeString = this.getDateTimeTypeString(database);
        LiquibaseDataType varchar255ColumnType = DataTypeFactory.getInstance().fromDescription(charTypeName + "(" + 255 + ")", database);
        LiquibaseDataType varchar2500ColumnType = DataTypeFactory.getInstance().fromDescription(charTypeName + "(" + 2500 + ")", database);
        CreateTableStatement createTableStatement = new CreateTableStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), DatabaseChangelogHistoryConfiguration.getTableName(database)).setTablespace(database.getLiquibaseTablespaceName()).addColumn(DatabaseChangeLogHistoryColumns.ID.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.AUTHOR.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.FILENAME.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.COMMAND.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.INTERNAL_COMMAND.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.ARGUMENTS.getColumnName(), varchar2500ColumnType).addColumn(DatabaseChangeLogHistoryColumns.OUTCOME.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.START.getColumnName(), DataTypeFactory.getInstance().fromDescription(dateTimeTypeString, database)).addColumn(DatabaseChangeLogHistoryColumns.END.getColumnName(), DataTypeFactory.getInstance().fromDescription(dateTimeTypeString, database)).addColumn(DatabaseChangeLogHistoryColumns.TAG.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.CONTEXTS.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.LABELS.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.MD5SUM.getColumnName(), DataTypeFactory.getInstance().fromDescription(charTypeName + "(35)", database)).addColumn(DatabaseChangeLogHistoryColumns.DESCRIPTION.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.COMMENTS.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.DEPLOYMENT_ID.getColumnName(), DataTypeFactory.getInstance().fromDescription(charTypeName + "(10)", database)).addColumn(DatabaseChangeLogHistoryColumns.EXECUTEDSQL.getColumnName(), DataTypeFactory.getInstance().fromDescription("CLOB", database)).addColumn(DatabaseChangeLogHistoryColumns.LIQUIBASEVERSION.getColumnName(), DataTypeFactory.getInstance().fromDescription(charTypeName + "(20)", database)).addColumn(DatabaseChangeLogHistoryColumns.HOSTNAME.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.SYSTEMUSER.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.INTERFACE.getColumnName(), varchar255ColumnType).addColumn(DatabaseChangeLogHistoryColumns.EXTENSIONS.getColumnName(), DataTypeFactory.getInstance().fromDescription("CLOB", database));
        try (TempObjectQuotingStrategy tempObjectQuotingStrategy = database.temporarilySetObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);){
            Sql[] sqlArray = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)createTableStatement, database);
            return sqlArray;
        }
    }

    protected String getCharTypeName(Database database) {
        if (database instanceof MSSQLDatabase && ((MSSQLDatabase)database).sendsStringParametersAsUnicode()) {
            return "nvarchar";
        }
        return "varchar";
    }

    protected String getDateTimeTypeString(Database database) {
        if (database instanceof MSSQLDatabase) {
            return "datetime2(3)";
        }
        return "datetime";
    }
}

