/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import com.datical.liquibase.ext.command.ScriptCommandStep;
import com.datical.liquibase.ext.command.checks.CustomScriptArguments;
import java.io.IOException;
import liquibase.Scope;
import liquibase.command.CommandScope;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;

public class CustomScriptUtil {
    public static Resource getScriptResource(String scriptName, CommandScope commandScope) throws IOException {
        CustomScriptArguments customScriptArguments = CustomScriptUtil.getCustomScriptArguments(commandScope);
        return CustomScriptUtil.getResource(scriptName, customScriptArguments);
    }

    public static CustomScriptArguments getCustomScriptArguments(CommandScope commandScope) {
        CustomScriptArguments customScriptArguments = (CustomScriptArguments)Scope.getCurrentScope().get("customScriptArguments", CustomScriptArguments.class);
        if (customScriptArguments == null && commandScope != null) {
            customScriptArguments = (CustomScriptArguments)commandScope.getDependency(CustomScriptArguments.class);
        }
        return customScriptArguments;
    }

    private static Resource getResource(String scriptName, CustomScriptArguments customScriptArguments) throws IOException {
        ResourceAccessor resourceAccessor;
        String scriptPathList;
        String string = scriptPathList = customScriptArguments == null ? null : customScriptArguments.getPathList();
        if (scriptPathList != null) {
            Scope.getCurrentScope().getLog(ScriptCommandStep.class).info(String.format("Using script path(s): '%s'", scriptPathList));
            resourceAccessor = new SearchPathResourceAccessor(scriptPathList, new ResourceAccessor[]{Scope.getCurrentScope().getResourceAccessor()});
        } else {
            Scope.getCurrentScope().getLog(ScriptCommandStep.class).info("No script path found. Using configured resource accessors.");
            resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        }
        Resource scriptResource = resourceAccessor.get(scriptName);
        if (!scriptResource.exists()) {
            String message = String.format("Unable to locate script '%s'", scriptName);
            if (scriptPathList != null) {
                message = String.format("%s in scripts paths '%s'", message, scriptPathList);
            }
            Scope.getCurrentScope().getLog(ScriptCommandStep.class).warning(message);
        }
        return scriptResource;
    }
}

