/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.Merge;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeDelete;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeInsert;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeOperationVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeUpdate;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateSet;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class MergeValidator
extends AbstractValidator<Merge>
implements MergeOperationVisitor {
    @Override
    public void validate(Merge merge) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.merge);
        }
        this.validateOptionalExpression(merge.getOnCondition());
        if (merge.getOperations() != null) {
            merge.getOperations().forEach(operation -> operation.accept(this));
        }
        this.validateOptionalFromItems(merge.getFromItem());
    }

    @Override
    public void visit(MergeDelete mergeDelete) {
        this.validateOptionalExpression(mergeDelete.getAndPredicate());
    }

    @Override
    public void visit(MergeUpdate mergeUpdate) {
        this.validateOptionalExpression(mergeUpdate.getAndPredicate());
        for (UpdateSet updateSet : mergeUpdate.getUpdateSets()) {
            this.validateOptionalExpressions(updateSet.getColumns());
            this.validateOptionalExpressions(updateSet.getValues());
        }
        this.validateOptionalExpression(mergeUpdate.getDeleteWhereCondition());
        this.validateOptionalExpression(mergeUpdate.getWhereCondition());
    }

    @Override
    public void visit(MergeInsert mergeInsert) {
        this.validateOptionalExpression(mergeInsert.getAndPredicate());
        this.validateOptionalExpressions(mergeInsert.getColumns());
        this.validateOptionalExpressions(mergeInsert.getValues());
    }
}

