/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.auth;

import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.java.truelicense.core.auth.Artifactory;
import net.java.truelicense.core.auth.EncodedArtifact;
import net.java.truelicense.core.auth.Repository;
import net.java.truelicense.core.auth.RepositoryIntegrityException;
import net.java.truelicense.core.auth.RepositoryModel;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.core.codec.Codecs;
import net.java.truelicense.core.io.MemoryStore;
import org.apache.commons.codec.binary.Base64;

@XmlRootElement(name="repository")
@XmlType(name="repository")
public final class BasicRepository
extends RepositoryModel
implements Repository {
    private final Base64 base64 = new Base64();

    @Override
    public final RepositoryModel model() {
        return this;
    }

    @Nullable
    private byte[] data(Codec codec, @CheckForNull String string) {
        if (null == string) {
            return null;
        }
        Charset charset = Codecs.charset(codec);
        return null != charset ? string.getBytes(charset) : this.decode(string);
    }

    @Nullable
    private byte[] decode(@CheckForNull String string) {
        return this.base64.decode(string);
    }

    @Nullable
    private String body(Codec codec, @CheckForNull byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        Charset charset = Codecs.charset(codec);
        return null != charset ? new String(byArray, charset) : this.encode(byArray);
    }

    @Nullable
    private String encode(@CheckForNull byte[] byArray) {
        return this.base64.encodeToString(byArray);
    }

    @Override
    public final Artifactory sign(Codec codec, Signature signature, PrivateKey privateKey, @Nullable Object object) throws Exception {
        MemoryStore memoryStore = new MemoryStore();
        codec.encode(memoryStore, object);
        byte[] byArray = memoryStore.data();
        signature.initSign(privateKey);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        String string = this.body(codec, byArray);
        String string2 = this.encode(byArray2);
        String string3 = signature.getAlgorithm();
        EncodedArtifact encodedArtifact = new EncodedArtifact(codec, memoryStore);
        RepositoryModel repositoryModel = this.model();
        repositoryModel.setArtifact(string);
        repositoryModel.setSignature(string2);
        repositoryModel.setAlgorithm(string3);
        return encodedArtifact;
    }

    @Override
    public final Artifactory verify(Codec codec, Signature signature, PublicKey publicKey) throws Exception {
        RepositoryModel repositoryModel = this.model();
        if (!signature.getAlgorithm().equalsIgnoreCase(repositoryModel.getAlgorithm())) {
            throw new IllegalArgumentException();
        }
        signature.initVerify(publicKey);
        byte[] byArray = this.data(codec, repositoryModel.getArtifact());
        signature.update(byArray);
        if (!signature.verify(this.decode(repositoryModel.getSignature()))) {
            throw new RepositoryIntegrityException();
        }
        return new EncodedArtifact(codec, byArray);
    }
}

