/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.util.ArrayList;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.plugins.MavenResourceAccessor;

public abstract class AbstractLiquibaseChangeLogMojo
extends AbstractLiquibaseMojo {
    protected String changeLogDirectory;
    protected String changeLogFile;
    protected String contexts;
    protected String labels;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.changeLogFile == null) {
            throw new MojoFailureException("The changeLogFile must be specified.");
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "changeLogDirectory: " + this.changeLogDirectory));
        this.getLog().info((CharSequence)(indent + "changeLogFile: " + this.changeLogFile));
        this.getLog().info((CharSequence)(indent + "context(s): " + this.contexts));
        this.getLog().info((CharSequence)(indent + "label(s): " + this.labels));
    }

    @Override
    protected ResourceAccessor getFileOpener(ClassLoader cl) {
        ArrayList<MavenResourceAccessor> resourceAccessors = new ArrayList<MavenResourceAccessor>();
        resourceAccessors.add(new MavenResourceAccessor(cl));
        resourceAccessors.add((MavenResourceAccessor)new FileSystemResourceAccessor(this.project.getBasedir().getAbsolutePath()));
        if (this.changeLogDirectory != null) {
            this.calculateChangeLogDirectoryAbsolutePath();
            resourceAccessors.add((MavenResourceAccessor)new FileSystemResourceAccessor(this.changeLogDirectory));
        }
        return new CompositeResourceAccessor(resourceAccessors);
    }

    @Override
    protected Liquibase createLiquibase(ResourceAccessor fo, Database db) throws MojoExecutionException {
        String changeLog = this.changeLogFile == null ? "" : this.changeLogFile.trim();
        return new Liquibase(changeLog, fo, db);
    }

    private void calculateChangeLogDirectoryAbsolutePath() {
        if (this.changeLogDirectory != null) {
            this.changeLogDirectory = this.changeLogDirectory.trim().replace('\\', '/');
            File changeLogDirectoryFile = new File(this.changeLogDirectory);
            if (!changeLogDirectoryFile.isAbsolute()) {
                this.changeLogDirectory = this.project.getBasedir().getAbsolutePath().replace('\\', '/') + "/" + this.changeLogDirectory;
            }
        }
    }
}

