/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Liquibase;
import liquibase.changelog.ChangeLogParameters;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandFactory;
import liquibase.command.LiquibaseCommand;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.plugins.MavenUtils;

public class LiquibaseRollbackOneChangeSetSQL
extends AbstractLiquibaseChangeLogMojo {
    protected String changeSetId;
    protected String changeSetAuthor;
    protected String changeSetPath;
    protected String rollbackScript;
    protected String outputFile;
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "Change Set ID:     " + this.changeSetId));
        this.getLog().info((CharSequence)(indent + "Change Set Author: " + this.changeSetAuthor));
        this.getLog().info((CharSequence)(indent + "Change Set Path:   " + this.changeSetPath));
        this.getLog().info((CharSequence)(indent + "Rollback script:   " + this.rollbackScript));
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.commandName = "rollbackOneChangeSetSQL";
        super.execute();
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        boolean hasProLicense = MavenUtils.checkProLicense(this.liquibaseProLicenseKey, this.commandName, this.getLog());
        if (!hasProLicense) {
            throw new LiquibaseException("The command 'rollbackOneChangeSetSQL' requires a Liquibase Pro License, available at http://liquibase.org.");
        }
        Database database = liquibase.getDatabase();
        LiquibaseCommand liquibaseCommand = CommandFactory.getInstance().getCommand("rollbackOneChangeSet");
        AbstractSelfConfiguratingCommand configuratingCommand = (AbstractSelfConfiguratingCommand)liquibaseCommand;
        Map<String, Object> argsMap = this.getCommandArgsObjectMap(liquibase);
        ChangeLogParameters clp = new ChangeLogParameters(database);
        Writer outputWriter = null;
        try {
            outputWriter = this.createOutputWriter();
            argsMap.put("outputWriter", outputWriter);
        }
        catch (IOException ioe) {
            throw new LiquibaseException("Error executing rollbackOneChangeSet.  Unable to create output writer.", (Throwable)ioe);
        }
        argsMap.put("changeLogParameters", clp);
        argsMap.put("liquibase", liquibase);
        configuratingCommand.configure(argsMap);
        try {
            liquibaseCommand.execute();
        }
        catch (CommandExecutionException cee) {
            throw new LiquibaseException("Error executing rollbackOneChangeSet", (Throwable)cee);
        }
        finally {
            try {
                outputWriter.flush();
                this.closeOutputWriter(outputWriter);
            }
            catch (IOException ioe) {
                LogService.getLog(((Object)((Object)this)).getClass()).info(LogType.LOG, String.format("Unable to close output file", new Object[0]));
            }
        }
    }

    private OutputStream getOutputStream() throws IOException {
        FileOutputStream fileOut;
        if (this.outputFile == null) {
            return System.out;
        }
        try {
            fileOut = new FileOutputStream(this.outputFile, false);
        }
        catch (IOException e) {
            LogService.getLog(((Object)((Object)this)).getClass()).severe(LogType.LOG, String.format(coreBundle.getString("could.not.create.output.file"), this.outputFile));
            throw e;
        }
        return fileOut;
    }

    private void closeOutputWriter(Writer outputWriter) throws IOException {
        if (this.outputFile == null) {
            return;
        }
        outputWriter.close();
    }

    private Writer createOutputWriter() throws IOException {
        String charsetName = ((GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class)).getOutputEncoding();
        return new OutputStreamWriter(this.getOutputStream(), charsetName);
    }

    private Map<String, Object> getCommandArgsObjectMap(Liquibase liquibase) throws LiquibaseException {
        Database database = liquibase.getDatabase();
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        argsMap.put("force", true);
        argsMap.put("changeLogFile", this.changeLogFile);
        argsMap.put("database", database);
        argsMap.put("changeLog", liquibase.getDatabaseChangeLog());
        argsMap.put("resourceAccessor", liquibase.getResourceAccessor());
        argsMap.put("changeSetId", this.changeSetId);
        argsMap.put("changeSetAuthor", this.changeSetAuthor);
        argsMap.put("changeSetPath", this.changeSetPath);
        return argsMap;
    }
}

