/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.magicwerk.brownies.collections.BigList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.primitive.IntBigList;

public class IntObjBigList
extends IList<Integer> {
    IntBigList list;

    static Integer[] toWrapper(int[] elems) {
        Integer[] e = new Integer[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static int[] toPrimitive(Integer[] elems) {
        int[] e = new int[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static int[] toPrimitive(BigList<? extends Integer> list2) {
        int[] e = new int[list2.size()];
        for (int i = 0; i < e.length; ++i) {
            e[i] = (Integer)list2.get(i);
        }
        return e;
    }

    static int[] toPrimitive(Collection<? extends Integer> list) {
        int[] e = new int[list.size()];
        Iterator<? extends Integer> iter = list.iterator();
        for (int i = 0; i < e.length; ++i) {
            e[i] = iter.next();
        }
        return e;
    }

    public static IntObjBigList create() {
        return new IntObjBigList();
    }

    public static IntObjBigList create(Integer ... elems) {
        IntObjBigList list = new IntObjBigList();
        list.init(elems);
        return list;
    }

    public static IntObjBigList create(Collection<? extends Integer> elems) {
        return new IntObjBigList(elems);
    }

    public IntObjBigList() {
        this.init();
    }

    public void init() {
        this.list = new IntBigList();
    }

    public IntObjBigList(int capacity) {
        this.list = new IntBigList(capacity);
    }

    public void init(Integer ... elems) {
        this.list = IntBigList.create(IntObjBigList.toPrimitive(elems));
    }

    public IntObjBigList(Collection<? extends Integer> elems) {
        this.init(elems);
    }

    public void init(Collection<? extends Integer> elems) {
        this.list = IntBigList.create(IntObjBigList.toPrimitive(elems));
    }

    @Override
    protected void doClone(IList<Integer> that) {
        this.list = (IntBigList)((IntObjBigList)that).list.clone();
    }

    @Override
    protected void doAssign(IList<Integer> that) {
        IntObjBigList list = (IntObjBigList)that;
        this.list = list.list;
    }

    public IntObjBigList copy() {
        return (IntObjBigList)this.clone();
    }

    @Override
    public Integer getDefaultElem() {
        return this.list.getDefaultElem();
    }

    @Override
    public IList<Integer> doCreate(int capacity) {
        return new IntObjBigList();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public Integer get(int index) {
        return this.list.get(index);
    }

    @Override
    protected Integer doGet(int index) {
        return this.list.doGet(index);
    }

    @Override
    protected void doGetAll(Object[] elems, int index, int len) {
        for (int i = 0; i < len; ++i) {
            elems[i] = this.list.doGet(index + i);
        }
    }

    @Override
    protected boolean doAdd(int index, Integer elem) {
        return this.list.doAdd(index, elem);
    }

    @Override
    protected Integer doSet(int index, Integer elem) {
        return this.list.doSet(index, elem);
    }

    @Override
    protected Integer doRemove(int index) {
        return this.list.doRemove(index);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        this.list.doRemoveAll(index, len);
    }

    @Override
    protected Integer doReSet(int index, Integer elem) {
        return this.list.doReSet(index, elem);
    }

    @Override
    public void move(int srcIndex, int dstIndex, int len) {
        this.list.move(srcIndex, dstIndex, len);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.list.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null || elem.getClass() != Integer.class) {
            return -1;
        }
        return this.list.indexOf((Integer)elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null || elem.getClass() != Integer.class) {
            return -1;
        }
        return this.list.lastIndexOf((Integer)elem);
    }

    @Override
    public boolean remove(Object elem) {
        if (elem == null || elem.getClass() != Integer.class) {
            return false;
        }
        int index = this.list.indexOf((Integer)elem);
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null || elem.getClass() != Integer.class) {
            return false;
        }
        return this.list.contains((Integer)elem);
    }

    @Override
    public boolean containsAny(Collection<?> coll) {
        return this.list.containsAny(coll);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(0, this.size());
    }

    @Override
    public Object[] toArray(int index, int len) {
        Object[] elems = new Object[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = this.list.get(i);
        }
        return elems;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.list.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        for (int i = 0; i < size; ++i) {
            array[i] = this.list.get(i);
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> coll) {
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> coll) {
        return this.list.addAll(index, coll);
    }

    public boolean addArray(Integer ... elems) {
        int[] e = IntObjBigList.toPrimitive(elems);
        return this.list.addArray(e);
    }

    public boolean addArray(int index, Integer ... elems) {
        int[] e = IntObjBigList.toPrimitive(elems);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean addAll(IList<? extends Integer> list2) {
        int[] e = IntObjBigList.toPrimitive(list2);
        return this.list.addArray(e);
    }

    @Override
    public boolean addAll(int index, IList<? extends Integer> list2) {
        int[] e = IntObjBigList.toPrimitive(list2);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Integer.class) {
            return false;
        }
        return this.list.removeFirstOccurrence((Integer)elem);
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Integer.class) {
            return false;
        }
        return this.list.removeLastOccurrence((Integer)elem);
    }

    @Override
    public BigList<Integer> getAll(int index, int len) {
        int[] elems = this.list.getArray(index, len);
        return BigList.create(IntObjBigList.toWrapper(elems));
    }

    public Integer[] getArray(int index, int len) {
        int[] elems = this.list.getArray(index, len);
        return IntObjBigList.toWrapper(elems);
    }

    @Override
    public void setAll(int index, IList<? extends Integer> list2) {
        int[] e = IntObjBigList.toPrimitive(list2);
        this.list.setArray(index, e);
    }

    @Override
    public void setAll(int index, Collection<? extends Integer> coll) {
        int[] e = IntObjBigList.toPrimitive(coll);
        this.list.setArray(index, e);
    }

    public void setArray(int index, Integer ... elems) {
        int[] e = IntObjBigList.toPrimitive(elems);
        this.list.setArray(index, e);
    }

    @Override
    public void sort(int index, int len, Comparator comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        this.list.sort(index, len);
    }

    @Override
    public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        return this.list.binarySearch(index, len, (Integer)key);
    }

    public IntObjBigList unmodifiableList() {
        return new ImmutableIntObjBigList(this);
    }

    protected static class ImmutableIntObjBigList
    extends IntObjBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableIntObjBigList(IntObjBigList that) {
            super(that);
        }

        @Override
        protected boolean doAdd(int index, Integer elem) {
            this.error();
            return false;
        }

        @Override
        protected Integer doSet(int index, Integer elem) {
            this.error();
            return null;
        }

        @Override
        protected Integer doReSet(int index, Integer elem) {
            this.error();
            return null;
        }

        @Override
        protected Integer doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

