/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbConnectionFactory;
import org.mariadb.r2dbc.util.Assert;

public final class MariadbConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String MARIADB_DRIVER = "mariadb";
    public static final Option<String> SOCKET = Option.valueOf((String)"socket");
    public static final Option<Boolean> ALLOW_MULTI_QUERIES = Option.valueOf((String)"allowMultiQueries");
    public static final Option<String> TLS_PROTOCOL = Option.valueOf((String)"tlsProtocol");
    public static final Option<String> SERVER_SSL_CERT = Option.valueOf((String)"serverSslCert");
    public static final Option<String> CLIENT_SSL_CERT = Option.valueOf((String)"clientSslCert");
    public static final Option<String> CLIENT_SSL_KEY = Option.valueOf((String)"clientSslKey");
    public static final Option<String> CLIENT_SSL_PWD = Option.valueOf((String)"clientSslPassword");
    public static final Option<Boolean> ALLOW_PIPELINING = Option.valueOf((String)"allowPipelining");
    public static final Option<Boolean> USE_SERVER_PREPARE = Option.valueOf((String)"useServerPrepStmts");
    public static final Option<Boolean> AUTO_COMMIT = Option.valueOf((String)"autoCommit");
    public static final Option<Boolean> TINY_IS_BIT = Option.valueOf((String)"tinyInt1isBit");
    public static final Option<Integer> PREPARE_CACHE_SIZE = Option.valueOf((String)"prepareCacheSize");
    public static final Option<String> SSL_MODE = Option.valueOf((String)"sslMode");
    public static final Option<String> CONNECTION_ATTRIBUTES = Option.valueOf((String)"connectionAttributes");
    public static final Option<String> PAM_OTHER_PASSWORD = Option.valueOf((String)"pamOtherPwd");
    public static final Option<Duration> SOCKET_TIMEOUT = Option.valueOf((String)"socketTimeout");
    public static final Option<Boolean> TCP_KEEP_ALIVE = Option.valueOf((String)"tcpKeepAlive");
    public static final Option<Boolean> TCP_ABORTIVE_CLOSE = Option.valueOf((String)"tcpAbortiveClose");
    public static final Option<String> SESSION_VARIABLES = Option.valueOf((String)"sessionVariables");

    static MariadbConnectionConfiguration createConfiguration(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        return MariadbConnectionConfiguration.fromOptions(connectionFactoryOptions).build();
    }

    public MariadbConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        return new MariadbConnectionFactory(MariadbConnectionFactoryProvider.createConfiguration(connectionFactoryOptions));
    }

    public String getDriver() {
        return MARIADB_DRIVER;
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        String driver = (String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return MARIADB_DRIVER.equals(driver);
    }
}

