/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.MariadbRow;
import org.mariadb.r2dbc.MariadbRowMetadata;
import org.mariadb.r2dbc.codec.BinaryRowDecoder;
import org.mariadb.r2dbc.codec.RowDecoder;
import org.mariadb.r2dbc.codec.TextRowDecoder;
import org.mariadb.r2dbc.message.server.ColumnCountPacket;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.CompletePrepareResult;
import org.mariadb.r2dbc.message.server.ErrorPacket;
import org.mariadb.r2dbc.message.server.OkPacket;
import org.mariadb.r2dbc.message.server.RowPacket;
import org.mariadb.r2dbc.message.server.ServerMessage;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class MariadbResult
implements org.mariadb.r2dbc.api.MariadbResult {
    private final Flux<ServerMessage> dataRows;
    private final ExceptionFactory factory;
    private RowDecoder decoder;
    private final String[] generatedColumns;
    private final boolean supportReturning;
    private final boolean text;
    private final MariadbConnectionConfiguration conf;
    private AtomicReference<ServerPrepareResult> prepareResult;
    private volatile ColumnDefinitionPacket[] metadataList;
    private volatile int metadataIndex;
    private volatile int columnNumber;
    private volatile MariadbRowMetadata rowMetadata;

    MariadbResult(boolean text, AtomicReference<ServerPrepareResult> prepareResult, Flux<ServerMessage> dataRows, ExceptionFactory factory, String[] generatedColumns, boolean supportReturning, MariadbConnectionConfiguration conf) {
        this.text = text;
        this.dataRows = dataRows;
        this.factory = factory;
        this.generatedColumns = generatedColumns;
        this.supportReturning = supportReturning;
        this.conf = conf;
        this.prepareResult = prepareResult;
    }

    @Override
    public Mono<Integer> getRowsUpdated() {
        Flux f = this.dataRows.handle((serverMessage, sink) -> {
            if (serverMessage instanceof ErrorPacket) {
                sink.error((Throwable)this.factory.from((ErrorPacket)serverMessage));
                return;
            }
            if (serverMessage instanceof OkPacket) {
                OkPacket okPacket = (OkPacket)serverMessage;
                long affectedRows = okPacket.getAffectedRows();
                sink.next((Object)((int)affectedRows));
                sink.complete();
            }
        });
        return f.singleOrEmpty();
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        this.metadataIndex = 0;
        return this.dataRows.takeUntil(msg -> msg.resultSetEnd()).handle((serverMessage, sink) -> {
            if (serverMessage instanceof ErrorPacket) {
                sink.error((Throwable)this.factory.from((ErrorPacket)serverMessage));
                return;
            }
            if (serverMessage instanceof CompletePrepareResult) {
                this.prepareResult.set(((CompletePrepareResult)serverMessage).getPrepare());
                this.metadataList = this.prepareResult.get().getColumns();
                return;
            }
            if (serverMessage instanceof ColumnCountPacket) {
                this.columnNumber = ((ColumnCountPacket)serverMessage).getColumnCount();
                if (!((ColumnCountPacket)serverMessage).isMetaFollows()) {
                    this.metadataList = this.prepareResult.get().getColumns();
                    this.rowMetadata = MariadbRowMetadata.toRowMetadata(this.metadataList);
                    this.decoder = new BinaryRowDecoder(this.columnNumber, this.metadataList, this.conf);
                } else {
                    this.metadataList = new ColumnDefinitionPacket[this.columnNumber];
                }
                return;
            }
            if (serverMessage instanceof ColumnDefinitionPacket) {
                this.metadataList[this.metadataIndex++] = (ColumnDefinitionPacket)serverMessage;
                if (this.metadataIndex == this.columnNumber) {
                    this.rowMetadata = MariadbRowMetadata.toRowMetadata(this.metadataList);
                    this.decoder = this.text ? new TextRowDecoder(this.columnNumber, this.metadataList, this.conf) : new BinaryRowDecoder(this.columnNumber, this.metadataList, this.conf);
                }
                return;
            }
            if (serverMessage instanceof RowPacket) {
                ByteBuf buf = ((RowPacket)serverMessage).getRaw();
                try {
                    sink.next(f.apply(new MariadbRow(this.metadataList, this.decoder, buf), this.rowMetadata));
                }
                catch (IllegalArgumentException i) {
                    sink.error((Throwable)this.factory.createException(i.getMessage(), "HY000", -1));
                }
                finally {
                    buf.release();
                }
                return;
            }
            if (this.generatedColumns != null && !this.supportReturning && serverMessage instanceof OkPacket) {
                String colName = this.generatedColumns.length > 0 ? this.generatedColumns[0] : "ID";
                this.metadataList = new ColumnDefinitionPacket[1];
                this.metadataList[0] = ColumnDefinitionPacket.fromGeneratedId(colName);
                this.rowMetadata = MariadbRowMetadata.toRowMetadata(this.metadataList);
                OkPacket okPacket = (OkPacket)serverMessage;
                if (okPacket.getAffectedRows() > 1L) {
                    sink.error((Throwable)this.factory.createException("Connector cannot get generated ID (using returnGeneratedValues) multiple rows before MariaDB 10.5.1", "HY000", -1));
                    return;
                }
                ByteBuf buf = this.getLongTextEncoded(okPacket.getLastInsertId());
                this.decoder = new TextRowDecoder(1, this.metadataList, this.conf);
                try {
                    sink.next(f.apply(new MariadbRow(this.metadataList, this.decoder, buf), this.rowMetadata));
                }
                finally {
                    buf.release();
                }
            }
        });
    }

    private ByteBuf getLongTextEncoded(long value) {
        byte[] byteValue = Long.toString(value).getBytes(StandardCharsets.US_ASCII);
        int length = byteValue.length;
        byte[] encodedLength = new byte[]{(byte)length};
        return Unpooled.copiedBuffer((byte[][])new byte[][]{encodedLength, byteValue});
    }
}

