/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.util.List;
import java.util.Queue;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.CmdElement;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.PrepareResultPacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.ServerMessage;
import org.mariadb.r2dbc.util.BufferUtils;
import org.mariadb.r2dbc.util.PrepareCache;
import org.mariadb.r2dbc.util.ServerPrepareResult;

public class MariadbPacketDecoder
extends ByteToMessageDecoder {
    private final Queue<CmdElement> responseReceivers;
    private final Client client;
    private Context context = null;
    private boolean isMultipart = false;
    private DecoderState state = DecoderState.INIT_HANDSHAKE;
    private CmdElement cmdElement;
    private CompositeByteBuf multipart;
    private long serverCapabilities;
    private int stateCounter = 0;
    private PrepareResultPacket prepare;
    private ColumnDefinitionPacket[] prepareColumns;

    public MariadbPacketDecoder(Queue<CmdElement> responseReceivers, Client client) {
        this.responseReceivers = responseReceivers;
        this.client = client;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        while (buf.readableBytes() > 4) {
            int length = buf.getUnsignedMediumLE(buf.readerIndex());
            if (buf.readableBytes() < length + 4) {
                return;
            }
            if (length == 0xFFFFFF) {
                if (!this.isMultipart) {
                    this.isMultipart = true;
                    this.multipart = buf.alloc().compositeBuffer();
                }
                buf.skipBytes(4);
                this.multipart.addComponent(true, buf.readRetainedSlice(length));
                continue;
            }
            if (this.isMultipart) {
                buf.skipBytes(3);
                Sequencer sequencer = new Sequencer(buf.readByte());
                this.multipart.addComponent(true, buf.readRetainedSlice(length));
                this.handleBuffer((ByteBuf)this.multipart, sequencer);
                this.multipart.release();
                this.isMultipart = false;
                continue;
            }
            ByteBuf packet = buf.readRetainedSlice(4 + length);
            packet.skipBytes(3);
            Sequencer sequencer = new Sequencer(packet.readByte());
            this.handleBuffer(packet, sequencer);
            packet.release();
        }
    }

    private void handleBuffer(ByteBuf packet, Sequencer sequencer) {
        if (this.cmdElement == null && !this.loadNextResponse()) {
            throw new R2dbcNonTransientResourceException(String.format("unexpected message received when no command was send: 0x%s", BufferUtils.toString(packet)));
        }
        this.state = this.state.decoder(packet.getUnsignedByte(packet.readerIndex()), packet.readableBytes(), this.serverCapabilities);
        ServerMessage msg = this.state.decode(packet, sequencer, this, this.cmdElement);
        this.cmdElement.getSink().next((Object)msg);
        if (msg.ending()) {
            if (this.cmdElement != null) {
                CmdElement element = this.cmdElement;
                this.loadNextResponse();
                element.getSink().complete();
            }
            this.client.sendNext();
        } else {
            this.state = this.state.next(this);
        }
    }

    public void connectionError(Throwable err) {
        if (this.cmdElement != null) {
            this.cmdElement.getSink().error(err);
            this.cmdElement = null;
            this.state = null;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public int getStateCounter() {
        return this.stateCounter;
    }

    public void setStateCounter(int counter) {
        this.stateCounter = counter;
    }

    public PrepareResultPacket getPrepare() {
        return this.prepare;
    }

    public void setPrepare(PrepareResultPacket prepare) {
        this.prepare = prepare;
        this.prepareColumns = new ColumnDefinitionPacket[prepare.getNumColumns()];
    }

    public ColumnDefinitionPacket[] getPrepareColumns() {
        return this.prepareColumns;
    }

    public ServerPrepareResult endPrepare() {
        ServerPrepareResult cached;
        ServerPrepareResult prepareResult = new ServerPrepareResult(this.prepare.getStatementId(), this.prepare.getNumParams(), this.prepareColumns);
        PrepareCache prepareCache = this.client.getPrepareCache();
        if (prepareCache != null && (cached = prepareCache.put(this.cmdElement.getSql(), prepareResult)) != null) {
            prepareResult.decrementUse(this.client);
            prepareResult = cached;
        }
        this.prepare = null;
        return prepareResult;
    }

    public void decrementStateCounter() {
        --this.stateCounter;
    }

    public long getServerCapabilities() {
        return this.serverCapabilities;
    }

    private boolean loadNextResponse() {
        this.cmdElement = this.responseReceivers.poll();
        if (this.cmdElement != null) {
            this.state = this.cmdElement.getInitialState();
            return true;
        }
        this.state = null;
        return false;
    }

    public void setContext(Context context) {
        this.context = context;
        this.serverCapabilities = this.context.getServerCapabilities();
    }
}

