/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BufferUtils;

public class BitSetCodec
implements Codec<BitSet> {
    public static final BitSetCodec INSTANCE = new BitSetCodec();

    public static BitSet parseBit(ByteBuf buf, int length) {
        byte[] arr = new byte[length];
        buf.readBytes(arr);
        BitSetCodec.revertOrder(arr);
        return BitSet.valueOf(arr);
    }

    public static void revertOrder(byte[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return column.getType() == DataType.BIT && type.isAssignableFrom(BitSet.class);
    }

    @Override
    public BitSet decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends BitSet> type) {
        return BitSetCodec.parseBit(buf, length);
    }

    @Override
    public BitSet decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends BitSet> type) {
        return BitSetCodec.parseBit(buf, length);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return BitSet.class.isAssignableFrom(value);
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, BitSet value) {
        byte[] bytes = value.toByteArray();
        BitSetCodec.revertOrder(bytes);
        StringBuilder sb = new StringBuilder(bytes.length * 8 + 3);
        sb.append("b'");
        for (int i = 0; i < 8 * bytes.length; ++i) {
            sb.append((bytes[i / 8] << i % 8 & 0x80) == 0 ? (char)'0' : '1');
        }
        sb.append("'");
        buf.writeCharSequence((CharSequence)sb.toString(), StandardCharsets.US_ASCII);
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, BitSet value) {
        byte[] bytes = value.toByteArray();
        BitSetCodec.revertOrder(bytes);
        BufferUtils.writeLengthEncode(bytes.length, buf);
        buf.writeBytes(bytes);
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.BLOB;
    }
}

