/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.list.LongCodec;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BufferUtils;

public class ByteCodec
implements Codec<Byte> {
    public static final ByteCodec INSTANCE = new ByteCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.YEAR, DataType.BIT, DataType.FLOAT, DataType.DOUBLE, DataType.OLDDECIMAL, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.VARCHAR});

    public static long parseBit(ByteBuf buf, int length) {
        if (length == 1) {
            return buf.readUnsignedByte();
        }
        long val = 0L;
        int idx = 0;
        do {
            val += (long)buf.readUnsignedByte() << 8 * length;
        } while (++idx < length);
        return val;
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Byte.TYPE || type.isAssignableFrom(Byte.class));
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Byte.class.isAssignableFrom(value);
    }

    @Override
    public Byte decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Byte> type) {
        long result;
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case YEAR: {
                result = LongCodec.parse(buf, length);
                break;
            }
            case BIT: {
                if (length == 0) {
                    return (byte)0;
                }
                Byte val = buf.readByte();
                if (length > 1) {
                    buf.skipBytes(length - 1);
                }
                return val;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (length == 0) {
                    return (byte)0;
                }
                byte b = buf.readByte();
                buf.skipBytes(length - 1);
                return b;
            }
            default: {
                String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).byteValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new R2dbcNonTransientResourceException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str, column.getType()}));
                }
            }
        }
        if ((long)((byte)result) != result || result < 0L && !column.isSigned()) {
            throw new R2dbcNonTransientResourceException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public Byte decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Byte> type) {
        long result;
        switch (column.getType()) {
            case TINYINT: {
                result = column.isSigned() ? (long)buf.readByte() : (long)buf.readUnsignedByte();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                result = column.isSigned() ? (long)buf.readShortLE() : (long)buf.readUnsignedShortLE();
                break;
            }
            case MEDIUMINT: {
                result = column.isSigned() ? (long)buf.readMediumLE() : (long)buf.readUnsignedMediumLE();
                break;
            }
            case INTEGER: {
                result = column.isSigned() ? (long)buf.readIntLE() : buf.readUnsignedIntLE();
                break;
            }
            case BIGINT: {
                if (column.isSigned()) {
                    result = buf.readLongLE();
                    break;
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                BigInteger val = new BigInteger(1, bb);
                result = val.longValue();
                break;
            }
            case BIT: {
                if (length == 0) {
                    return (byte)0;
                }
                Byte val = buf.readByte();
                if (length > 1) {
                    buf.skipBytes(length - 1);
                }
                return val;
            }
            case FLOAT: {
                float f = buf.readFloatLE();
                result = (long)f;
                if ((long)((byte)result) == result && (result >= 0L || column.isSigned())) break;
                throw new R2dbcNonTransientResourceException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{Float.valueOf(f), column.getType()}));
            }
            case DOUBLE: {
                double d = buf.readDoubleLE();
                result = (long)d;
                if ((long)((byte)result) == result && (result >= 0L || column.isSigned())) break;
                throw new R2dbcNonTransientResourceException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{d, column.getType()}));
            }
            case OLDDECIMAL: 
            case DECIMAL: 
            case ENUM: 
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).byteValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new R2dbcNonTransientResourceException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str, column.getType()}));
                }
            }
            default: {
                if (length == 0) {
                    return (byte)0;
                }
                byte b = buf.readByte();
                buf.skipBytes(length - 1);
                return b;
            }
        }
        if ((long)((byte)result) != result || result < 0L && !column.isSigned()) {
            throw new R2dbcNonTransientResourceException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public void encodeText(ByteBuf buf, Context context, Byte value) {
        BufferUtils.writeAscii(buf, Integer.toString(value.byteValue()));
    }

    @Override
    public void encodeBinary(ByteBuf buf, Context context, Byte value) {
        buf.writeByte((int)value.byteValue());
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.TINYINT;
    }
}

