/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Map;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.Parameter;
import org.mariadb.r2dbc.message.client.ClientMessage;
import org.mariadb.r2dbc.message.server.Sequencer;

public final class ExecutePacket
implements ClientMessage {
    private final Map<Integer, Parameter<?>> parameters;
    private final int statementId;
    private final Sequencer sequencer = new Sequencer(-1);

    public ExecutePacket(int statementId, Map<Integer, Parameter<?>> parameters) {
        this.parameters = parameters;
        this.statementId = statementId;
    }

    @Override
    public Sequencer getSequencer() {
        return this.sequencer;
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator allocator) {
        ByteBuf buf = allocator.ioBuffer();
        buf.writeByte(23);
        buf.writeIntLE(this.statementId);
        buf.writeByte(0);
        buf.writeIntLE(1);
        Integer[] keys = this.parameters.keySet().toArray(new Integer[0]);
        int parameterCount = 0;
        for (Integer i : keys) {
            if (i + 1 <= parameterCount) continue;
            parameterCount = i + 1;
        }
        if (parameterCount > 0) {
            Parameter<?> p;
            int i;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (i = 0; i < parameterCount; ++i) {
                p = this.parameters.get(i);
                if (p != null && !p.isNull()) continue;
                int n = i / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i % 8);
            }
            buf.writeBytes(nullBitsBuffer);
            buf.writeByte(1);
            for (i = 0; i < parameterCount; ++i) {
                p = this.parameters.get(i);
                if (p == null) {
                    buf.writeShortLE((int)DataType.VARCHAR.get());
                    continue;
                }
                buf.writeShortLE((int)p.getBinaryEncodeType().get());
            }
        }
        for (int i = 0; i < parameterCount; ++i) {
            Parameter<?> p = this.parameters.get(i);
            if (p == null || p.isNull()) continue;
            p.encodeBinary(buf, context);
        }
        return buf;
    }
}

