/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.client.Context;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.message.server.ServerMessage;
import org.mariadb.r2dbc.util.BufferUtils;

public class ColumnCountPacket
implements ServerMessage {
    private int columnCount;
    private boolean metaFollows;

    public ColumnCountPacket(int columnCount, boolean metaFollows) {
        this.columnCount = columnCount;
        this.metaFollows = metaFollows;
    }

    public static ColumnCountPacket decode(Sequencer sequencer, ByteBuf buf, Context context) {
        long columnCount = BufferUtils.readLengthEncodedInt(buf);
        if ((context.getServerCapabilities() & 0x1000000000L) > 0L) {
            byte metaFollow = buf.readByte();
            return new ColumnCountPacket((int)columnCount, metaFollow == 1);
        }
        return new ColumnCountPacket((int)columnCount, true);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean isMetaFollows() {
        return this.metaFollows;
    }
}

