/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.api.MariadbRow;
import org.mariadb.r2dbc.client.MariadbOutParameters;
import org.mariadb.r2dbc.client.MariadbOutParametersMetadata;
import org.mariadb.r2dbc.client.MariadbResult;
import org.mariadb.r2dbc.client.MariadbRow;
import org.mariadb.r2dbc.client.MariadbRowBinary;
import org.mariadb.r2dbc.client.MariadbRowMetadata;
import org.mariadb.r2dbc.client.MariadbRowText;
import org.mariadb.r2dbc.message.Protocol;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.ColumnCountPacket;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.CompletePrepareResult;
import org.mariadb.r2dbc.message.server.EofPacket;
import org.mariadb.r2dbc.message.server.ErrorPacket;
import org.mariadb.r2dbc.message.server.OkPacket;
import org.mariadb.r2dbc.message.server.RowPacket;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MariadbSegmentResult
extends AbstractReferenceCounted
implements org.mariadb.r2dbc.api.MariadbResult {
    private final Flux<Result.Segment> segments;

    private MariadbSegmentResult(Flux<Result.Segment> segments) {
        this.segments = segments;
    }

    MariadbSegmentResult(Protocol protocol, AtomicReference<ServerPrepareResult> prepareResult, Flux<ServerMessage> messages, ExceptionFactory factory, String[] generatedColumns, boolean supportReturning, MariadbConnectionConfiguration conf) {
        ArrayList columns = new ArrayList();
        AtomicBoolean metaFollows = new AtomicBoolean(true);
        AtomicReference rowConstructor = new AtomicReference();
        AtomicReference meta = new AtomicReference();
        AtomicBoolean isOutputParameter = new AtomicBoolean();
        this.segments = messages.handle((message, sink) -> {
            if (message instanceof CompletePrepareResult) {
                prepareResult.set(((CompletePrepareResult)message).getPrepare());
                return;
            }
            if (message instanceof ColumnCountPacket) {
                metaFollows.set(((ColumnCountPacket)message).isMetaFollows());
                if (!metaFollows.get()) {
                    columns.addAll(Arrays.asList(((ServerPrepareResult)prepareResult.get()).getColumns()));
                }
                return;
            }
            if (message instanceof ColumnDefinitionPacket) {
                columns.add((ColumnDefinitionPacket)message);
                return;
            }
            if (message instanceof EofPacket) {
                EofPacket eof = (EofPacket)message;
                if (!eof.ending()) {
                    rowConstructor.set(protocol == Protocol.TEXT ? MariadbRowText::new : MariadbRowBinary::new);
                    ColumnDefinitionPacket[] columnsArray = columns.toArray(new ColumnDefinitionPacket[0]);
                    meta.set(new MariadbRowMetadata(columnsArray));
                    if (prepareResult != null && prepareResult.get() != null && metaFollows.get()) {
                        ((ServerPrepareResult)prepareResult.get()).setColumns(columnsArray);
                    }
                    isOutputParameter.set((eof.getServerStatus() & 0x1000) > 0);
                }
                return;
            }
            if (message instanceof ErrorPacket) {
                sink.next((Object)new MariadbErrorSegment((ErrorPacket)message, factory));
                return;
            }
            if (message instanceof OkPacket) {
                Long rowCount;
                if (generatedColumns != null && !supportReturning) {
                    String colName = generatedColumns.length > 0 ? generatedColumns[0] : "ID";
                    MariadbRowMetadata tmpMeta = new MariadbRowMetadata(new ColumnDefinitionPacket[]{ColumnDefinitionPacket.fromGeneratedId(colName, conf)});
                    if (((OkPacket)message).value() > 1L) {
                        sink.error((Throwable)factory.createException("Connector cannot get generated ID (using returnGeneratedValues) multiple rows before MariaDB 10.5.1", "HY000", -1));
                        return;
                    }
                    ByteBuf buf = MariadbResult.getLongTextEncoded(((OkPacket)message).getLastInsertId());
                    MariadbRowText row = new MariadbRowText(buf, tmpMeta, factory);
                    sink.next((Object)new MariadbRowSegment(row, (ReferenceCounted)buf));
                }
                if ((rowCount = Long.valueOf(((OkPacket)message).value())) != null) {
                    sink.next((Object)new MariadbUpdateCountSegment(rowCount));
                }
                return;
            }
            if (message instanceof RowPacket) {
                RowPacket row = (RowPacket)message;
                if (isOutputParameter.get()) {
                    MariadbOutParameters outParameters = new MariadbOutParameters(row.getRaw(), new MariadbOutParametersMetadata(columns), factory);
                    sink.next((Object)new MariadbOutSegment(outParameters, (RowPacket)message));
                } else {
                    MariadbRow rowSegment = ((MariadbRow.MariadbRowConstructor)rowConstructor.get()).create(row.getRaw(), (MariadbRowMetadata)meta.get(), factory);
                    sink.next((Object)new MariadbRowSegment(rowSegment, (RowPacket)message));
                }
            }
        });
    }

    static MariadbSegmentResult toResult(Protocol protocol, AtomicReference<ServerPrepareResult> prepareResult, Flux<ServerMessage> messages, ExceptionFactory factory, String[] generatedColumns, boolean supportReturning, MariadbConnectionConfiguration conf) {
        return new MariadbSegmentResult(protocol, prepareResult, messages, factory, generatedColumns, supportReturning, conf);
    }

    @Override
    public Mono<Long> getRowsUpdated() {
        return this.segments.handle((segment, sink) -> {
            try {
                if (segment instanceof MariadbErrorSegment) {
                    sink.error((Throwable)((MariadbErrorSegment)segment).exception());
                    return;
                }
                if (segment instanceof Result.UpdateCount) {
                    sink.next((Object)((int)((Result.UpdateCount)segment).value()));
                }
            }
            finally {
                ReferenceCountUtil.release((Object)segment);
            }
        }).collectList().handle((list, sink) -> {
            if (list.isEmpty()) {
                return;
            }
            long sum = 0L;
            for (Integer integer : list) {
                sum += (long)integer.intValue();
            }
            sink.next((Object)sum);
        });
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        Assert.requireNonNull(f, "f must not be null");
        return this.segments.handle((segment, sink) -> {
            try {
                if (segment instanceof MariadbErrorSegment) {
                    sink.error((Throwable)((MariadbErrorSegment)segment).exception());
                    return;
                }
                if (segment instanceof Result.RowSegment) {
                    Result.RowSegment row = (Result.RowSegment)segment;
                    sink.next(f.apply(row.row(), row.row().getMetadata()));
                }
            }
            finally {
                ReferenceCountUtil.release((Object)segment);
            }
        });
    }

    public MariadbSegmentResult filter(Predicate<Result.Segment> filter) {
        Assert.requireNonNull(filter, "filter must not be null");
        return new MariadbSegmentResult((Flux<Result.Segment>)this.segments.filter(it -> {
            boolean result = filter.test((Result.Segment)it);
            if (!result) {
                ReferenceCountUtil.release((Object)it);
            }
            return result;
        }));
    }

    public <T> Publisher<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        Assert.requireNonNull(mappingFunction, "mappingFunction must not be null");
        return this.segments.concatMap(segment -> {
            Publisher result = (Publisher)mappingFunction.apply((Result.Segment)segment);
            if (result == null) {
                return Mono.error((Throwable)new IllegalStateException("The mapper returned a null Publisher"));
            }
            if (result instanceof Mono) {
                return ((Mono)result).doFinally(s -> ReferenceCountUtil.release((Object)segment));
            }
            return Flux.from((Publisher)result).doFinally(s -> ReferenceCountUtil.release((Object)segment));
        });
    }

    protected void deallocate() {
        this.getRowsUpdated().subscribe();
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    public String toString() {
        return "MariadbSegmentResult{segments=" + this.segments + '}';
    }

    static class MariadbErrorSegment
    implements Result.Message {
        private final ExceptionFactory factory;
        private final ErrorPacket error;

        public MariadbErrorSegment(ErrorPacket error, ExceptionFactory factory) {
            this.factory = factory;
            this.error = error;
        }

        public R2dbcException exception() {
            return this.factory.from(this.error);
        }

        public int errorCode() {
            return this.error.errorCode();
        }

        public String sqlState() {
            return this.error.sqlState();
        }

        public String message() {
            return this.error.getMessage();
        }
    }

    static class MariadbUpdateCountSegment
    implements Result.UpdateCount {
        private final long value;

        public MariadbUpdateCountSegment(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }
    }

    static class MariadbOutSegment
    extends AbstractReferenceCounted
    implements Result.OutSegment {
        private final OutParameters outParameters;
        private final ReferenceCounted releaseable;

        public MariadbOutSegment(OutParameters outParameters, ReferenceCounted releaseable) {
            this.outParameters = outParameters;
            this.releaseable = releaseable;
        }

        public OutParameters outParameters() {
            return this.outParameters;
        }

        protected void deallocate() {
            ReferenceCountUtil.release((Object)this.releaseable);
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }
    }

    static class MariadbRowSegment
    extends AbstractReferenceCounted
    implements Result.RowSegment {
        private final Row row;
        private final ReferenceCounted releaseable;

        public MariadbRowSegment(Row row, ReferenceCounted releaseable) {
            this.row = row;
            this.releaseable = releaseable;
        }

        public Row row() {
            return this.row;
        }

        protected void deallocate() {
            ReferenceCountUtil.release((Object)this.releaseable);
        }

        public ReferenceCounted touch(Object hint) {
            return this;
        }
    }
}

