/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import java.nio.charset.StandardCharsets;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.Assert;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class ErrorPacket
implements ServerMessage,
Result.Message {
    private static final Logger logger = Loggers.getLogger(ErrorPacket.class);
    private final short errorCode;
    private final String message;
    private final String sqlState;
    private final boolean ending;

    private ErrorPacket(short errorCode, String sqlState, String message, boolean ending) {
        this.errorCode = errorCode;
        this.message = message;
        this.sqlState = sqlState;
        this.ending = ending;
    }

    public static ErrorPacket decode(Sequencer sequencer, ByteBuf buf, boolean ending) {
        String msg;
        String sqlState;
        Assert.requireNonNull(buf, "buffer must not be null");
        buf.skipBytes(1);
        short errorCode = buf.readShortLE();
        byte next = buf.getByte(buf.readerIndex());
        if (next == 35) {
            buf.skipBytes(1);
            sqlState = buf.readCharSequence(5, StandardCharsets.UTF_8).toString();
            msg = buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8).toString();
        } else {
            msg = buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8).toString();
            sqlState = "HY000";
        }
        ErrorPacket err = new ErrorPacket(errorCode, sqlState, msg, ending);
        logger.warn("Error: '{}' sqlState='{}' code={} ", new Object[]{msg, sqlState, errorCode});
        return err;
    }

    public String getMessage() {
        return this.message;
    }

    public R2dbcException exception() {
        return ExceptionFactory.createException(this, null);
    }

    public int errorCode() {
        return this.errorCode;
    }

    public String sqlState() {
        return this.sqlState;
    }

    public String message() {
        return this.message;
    }

    @Override
    public boolean ending() {
        return this.ending;
    }
}

