/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.neo4j.driver.internal.util.Futures;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class RxUtils {
    public static <T> Publisher<T> createEmptyPublisher(Supplier<CompletionStage<Void>> supplier) {
        return Mono.create(sink -> ((CompletionStage)supplier.get()).whenComplete((ignore, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                sink.error(error);
            } else {
                sink.success();
            }
        }));
    }

    public static <T> Publisher<T> createSingleItemPublisher(Supplier<CompletionStage<T>> supplier, Supplier<Throwable> nullResultThrowableSupplier) {
        return Mono.create(sink -> ((CompletionStage)supplier.get()).whenComplete((arg_0, arg_1) -> RxUtils.lambda$createSingleItemPublisher$2(sink, (Supplier)nullResultThrowableSupplier, arg_0, arg_1)));
    }

    private static /* synthetic */ void lambda$createSingleItemPublisher$2(MonoSink sink, Supplier nullResultThrowableSupplier, Object item, Throwable completionError) {
        if (completionError == null) {
            if (item != null) {
                sink.success(item);
            } else {
                sink.error((Throwable)nullResultThrowableSupplier.get());
            }
        } else {
            Throwable error = Optional.ofNullable(Futures.completionExceptionCause(completionError)).orElse(completionError);
            sink.error(error);
        }
    }
}

