/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact.handlers.r41;

import java.io.IOException;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.xml.sax.SAXException;

class UNGHandler
implements ControlBlockHandler {
    private static Segment ungSegment;
    private static Segment uneSegment;

    UNGHandler() {
    }

    public void process(InterchangeContext interchangeContext) throws IOException, SAXException {
        BufferedSegmentReader segmentReader = interchangeContext.getSegmentReader();
        interchangeContext.getControlSegmentParser().startElement("group", true);
        segmentReader.moveToNextSegment(false);
        interchangeContext.mapControlSegment(ungSegment, true);
        while (true) {
            String segCode;
            if ((segCode = segmentReader.peek(3)).equals("UNE")) break;
            ControlBlockHandler handler = interchangeContext.getControlBlockHandler(segCode);
            handler.process(interchangeContext);
        }
        segmentReader.moveToNextSegment(false);
        interchangeContext.mapControlSegment(uneSegment, true);
        interchangeContext.getControlSegmentParser().endElement("group", true);
    }

    private static void createSegmentsDefs() {
        ungSegment = new Segment();
        ungSegment.setSegcode("UNG");
        ungSegment.setXmltag("UNG");
        ungSegment.setDescription("UNG - Group Header");
        ungSegment.setTruncatable(true);
        ungSegment.addField(new Field("groupId", false));
        ungSegment.addField(new Field("senderApp", false).addComponent(new Component("id", true)).addComponent(new Component("codeQualifier", false)));
        ungSegment.addField(new Field("recipientApp", false).addComponent(new Component("id", true)).addComponent(new Component("codeQualifier", false)));
        ungSegment.addField(new Field("dateTime", false).addComponent(new Component("date", true)).addComponent(new Component("time", true)));
        ungSegment.addField(new Field("groupRef", true));
        ungSegment.addField(new Field("controllingAgencyCode", false));
        ungSegment.addField(new Field("messageVersion", false).addComponent(new Component("versionNum", true)).addComponent(new Component("releaseNum", true)).addComponent(new Component("associationCode", false)));
        ungSegment.addField(new Field("applicationPassword", false));
        uneSegment = new Segment();
        uneSegment.setSegcode("UNE");
        uneSegment.setXmltag("UNE");
        uneSegment.setDescription("UNE - Group Trailer");
        uneSegment.setTruncatable(true);
        uneSegment.addField(new Field("controlCount", true));
        uneSegment.addField(new Field("groupRef", true));
    }

    static {
        UNGHandler.createSegmentsDefs();
    }
}

