/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact.handlers;

import java.io.IOException;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIParseException;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.internal.Segment;
import org.xml.sax.SAXException;

public class UNGHandler
implements ControlBlockHandler {
    private Segment ungSegment;
    private Segment uneSegment;

    public UNGHandler(Segment ungSegment, Segment uneSegment) {
        this.ungSegment = ungSegment;
        this.uneSegment = uneSegment;
    }

    public void process(InterchangeContext interchangeContext) throws IOException, SAXException {
        BufferedSegmentReader segmentReader;
        block1: {
            segmentReader = interchangeContext.getSegmentReader();
            interchangeContext.getControlSegmentParser().startElement("group", this.ungSegment.getNamespace(), true);
            segmentReader.moveToNextSegment(false);
            interchangeContext.mapControlSegment(this.ungSegment, true);
            while (true) {
                String segCode;
                if ((segCode = segmentReader.peek(3, true)).equals("UNE")) break block1;
                if (segCode.length() <= 0) break;
                ControlBlockHandler handler = interchangeContext.getControlBlockHandler(segCode);
                handler.process(interchangeContext);
            }
            throw new EDIParseException("Unexpected end of UN/EDIFACT data stream.  If stream was reset (e.g. after read charset was changed), please make sure underlying stream was properly reset.");
        }
        segmentReader.moveToNextSegment(false);
        interchangeContext.mapControlSegment(this.uneSegment, true);
        interchangeContext.getControlSegmentParser().endElement("group", this.ungSegment.getNamespace(), true);
    }
}

