/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.milyn.assertion.AssertArgument;

public class FlushMethod {
    final Method method;

    public FlushMethod(Method method) {
        AssertArgument.isNotNull(method, "method");
        this.method = method;
    }

    public void invoke(Object obj) {
        try {
            this.method.invoke(obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("The method [" + this.method + "] of the class [" + this.method.getDeclaringClass().getName() + "] threw an exception, while invoking it with the object [" + obj + "].", e);
        }
    }
}

