/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.camel.routing;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ExecutionLifecycleCleanable;
import org.milyn.delivery.ExecutionLifecycleInitializable;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.Uninitialize;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.expression.ExecutionContextExpressionEvaluator;
import org.milyn.smooks.camel.routing.BeanRouterObserver;
import org.milyn.util.FreeMarkerTemplate;
import org.milyn.util.FreeMarkerUtils;

public class BeanRouter
implements SAXVisitAfter,
Consumer,
ExecutionLifecycleInitializable,
ExecutionLifecycleCleanable {
    @ConfigParam
    private String beanId;
    @ConfigParam
    private String toEndpoint;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String correlationIdName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private FreeMarkerTemplate correlationIdPattern;
    @AppContext
    private ApplicationContext applicationContext;
    @Config
    SmooksResourceConfiguration routingConfig;
    private ProducerTemplate producerTemplate;
    private BeanRouterObserver camelRouterObserable;
    private CamelContext camelContext;

    public BeanRouter() {
    }

    public BeanRouter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Initialize
    public void initialize() {
        if (this.routingConfig == null) {
            this.routingConfig = new SmooksResourceConfiguration();
        }
        this.producerTemplate = this.getCamelContext().createProducerTemplate();
        if (this.isBeanRoutingConfigured()) {
            this.camelRouterObserable = new BeanRouterObserver(this, this.beanId);
            this.camelRouterObserable.setConditionEvaluator((ExecutionContextExpressionEvaluator)this.routingConfig.getConditionEvaluator());
        }
        if (this.correlationIdName != null && this.correlationIdPattern == null) {
            throw new SmooksConfigurationException("Camel router component configured with a 'correlationIdName', but 'correlationIdPattern' is not configured.");
        }
        if (this.correlationIdName == null && this.correlationIdPattern != null) {
            throw new SmooksConfigurationException("Camel router component configured with a 'correlationIdPattern', but 'correlationIdName' is not configured.");
        }
    }

    public BeanRouter setBeanId(String beanId) {
        this.beanId = beanId;
        return this;
    }

    public BeanRouter setToEndpoint(String toEndpoint) {
        this.toEndpoint = toEndpoint;
        return this;
    }

    public BeanRouter setCorrelationIdName(String correlationIdName) {
        AssertArgument.isNotNullAndNotEmpty(correlationIdName, "correlationIdName");
        this.correlationIdName = correlationIdName;
        return this;
    }

    public BeanRouter setCorrelationIdPattern(String correlationIdPattern) {
        this.correlationIdPattern = new FreeMarkerTemplate(correlationIdPattern);
        return this;
    }

    public void visitAfter(SAXElement element, ExecutionContext execContext) throws SmooksException, IOException {
        Object bean = this.getBeanFromExecutionContext(execContext, this.beanId);
        this.sendBean(bean, execContext);
    }

    protected void sendBean(final Object bean, final ExecutionContext execContext) {
        try {
            if (this.correlationIdPattern != null) {
                Processor processor = new Processor(){

                    public void process(Exchange exchange) {
                        Message in = exchange.getIn();
                        in.setBody(bean);
                        in.setHeader(BeanRouter.this.correlationIdName, (Object)BeanRouter.this.correlationIdPattern.apply(FreeMarkerUtils.getMergedModel(execContext)));
                    }
                };
                this.producerTemplate.send(this.toEndpoint, processor);
            } else {
                this.producerTemplate.sendBody(this.toEndpoint, bean);
            }
        }
        catch (Exception e) {
            throw new SmooksException("Exception routing beanId '" + this.beanId + "' to endpoint '" + this.toEndpoint + "'.", e);
        }
    }

    private Object getBeanFromExecutionContext(ExecutionContext execContext, String beanId) {
        Object bean = execContext.getBeanContext().getBean(beanId);
        if (bean == null) {
            throw new SmooksException("Exception routing beanId '" + beanId + "'. The bean was not found in the Smooks ExceutionContext.");
        }
        return bean;
    }

    private CamelContext getCamelContext() {
        if (this.camelContext == null) {
            return (CamelContext)this.applicationContext.getAttribute(CamelContext.class);
        }
        return this.camelContext;
    }

    private boolean isBeanRoutingConfigured() {
        return "none".equals(this.routingConfig.getSelector());
    }

    @Uninitialize
    public void uninitialize() {
        try {
            this.producerTemplate.stop();
        }
        catch (Exception e) {
            throw new SmooksException(e.getMessage(), e);
        }
    }

    public boolean consumes(Object object) {
        return this.beanId.equals(object);
    }

    public void executeExecutionLifecycleInitialize(ExecutionContext executionContext) {
        if (this.isBeanRoutingConfigured()) {
            executionContext.getBeanContext().addObserver(this.camelRouterObserable);
        }
    }

    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        if (this.isBeanRoutingConfigured()) {
            executionContext.getBeanContext().removeObserver(this.camelRouterObserable);
        }
    }
}

