/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

public class BundleClassLoaderDelegator
extends ClassLoader {
    private Bundle bundle;
    private ClassLoader classLoader;

    public BundleClassLoaderDelegator(Bundle bundle) {
        this.bundle = bundle;
    }

    public BundleClassLoaderDelegator(Bundle bundle, ClassLoader delegate) {
        this.bundle = bundle;
        this.classLoader = delegate;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            c = this.classLoader.loadClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.bundle.getResources(name);
    }

    @Override
    protected URL findResource(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (resource == null) {
            resource = this.classLoader.getResource(name);
        }
        return resource;
    }
}

