/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.expression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.expression.ExpressionEvaluationException;
import org.milyn.expression.ExpressionEvaluator;
import org.milyn.expression.MVELVariables;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;

public class MVELExpressionEvaluator
implements ExpressionEvaluator {
    private static final String MVEL_VARIABLES_VARIABLE_NAME = "VARS";
    private String expression;
    private Serializable compiled;
    private boolean containsVariablesVariable;
    private Class<?> toType;

    public MVELExpressionEvaluator() {
    }

    public MVELExpressionEvaluator(String expression) {
        this.setExpression(expression);
    }

    @Override
    public ExpressionEvaluator setExpression(String expression) throws SmooksConfigurationException {
        this.expression = expression.trim();
        this.compiled = MVEL.compileExpression((String)this.expression);
        this.containsVariablesVariable = this.expression.contains(MVEL_VARIABLES_VARIABLE_NAME);
        return this;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public void setToType(Class<?> toType) {
        this.toType = toType;
    }

    @Override
    public boolean eval(Object contextObject) throws ExpressionEvaluationException {
        return (Boolean)this.exec(contextObject);
    }

    public Object exec(Object contextObject, Map<String, Object> variableMap) throws ExpressionEvaluationException {
        try {
            if (this.containsVariablesVariable && contextObject instanceof Map) {
                MapVariableResolverFactory rootResolverFactory = new MapVariableResolverFactory(variableMap);
                MapVariableResolverFactory contextVariableResolverFactory = new MapVariableResolverFactory((Map)contextObject);
                rootResolverFactory.setNextFactory((VariableResolverFactory)contextVariableResolverFactory);
                rootResolverFactory.createVariable(MVEL_VARIABLES_VARIABLE_NAME, (Object)new MVELVariables((VariableResolverFactory)rootResolverFactory));
                if (this.toType != null) {
                    return DataConversion.convert((Object)MVEL.executeExpression((Object)this.compiled, (VariableResolverFactory)rootResolverFactory), this.toType);
                }
                return MVEL.executeExpression((Object)this.compiled, (VariableResolverFactory)rootResolverFactory);
            }
            if (this.toType != null) {
                return DataConversion.convert((Object)MVEL.executeExpression((Object)this.compiled, (Object)contextObject, (VariableResolverFactory)new MapVariableResolverFactory(variableMap)), this.toType);
            }
            return MVEL.executeExpression((Object)this.compiled, (Object)contextObject, (VariableResolverFactory)new MapVariableResolverFactory(variableMap));
        }
        catch (Exception e) {
            String msg = "Error evaluating MVEL expression '" + this.expression + "' against object type '" + contextObject.getClass().getName() + "'. " + "Common issues include:" + "\n\t\t1. Referencing a variable that is not bound into the context." + " In this case use the 'isdef' operator to check if the variable is bound in the context." + "\n\t\t2. Invalid expression reference to a List/Array based variable token.  Example List/Array referencing expression token: 'order.orderItems[0].productId'.";
            throw new ExpressionEvaluationException(msg, e);
        }
    }

    public Object exec(Object contextObject) throws ExpressionEvaluationException {
        return this.exec(contextObject, new HashMap<String, Object>());
    }

    @Override
    public Object getValue(Object contextObject) throws ExpressionEvaluationException {
        return this.exec(contextObject);
    }

    public Serializable getCompiled() {
        return this.compiled;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("expression", (Object)this.expression).append("toType", this.toType).toString();
    }
}

