/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.edi.unedifact.model.r41;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.unedifact.UNEdifactInterchangeParser;
import org.milyn.smooks.edi.EDIWritable;
import org.milyn.smooks.edi.unedifact.model.UNEdifactInterchange;
import org.milyn.smooks.edi.unedifact.model.r41.UNB41;
import org.milyn.smooks.edi.unedifact.model.r41.UNEdifactMessage41;
import org.milyn.smooks.edi.unedifact.model.r41.UNZ41;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UNEdifactInterchange41
implements UNEdifactInterchange {
    private static final long serialVersionUID = 1L;
    private Delimiters interchangeDelimiters;
    private UNB41 interchangeHeader;
    private UNZ41 interchangeTrailer;
    private List<UNEdifactMessage41> messages;

    public Delimiters getInterchangeDelimiters() {
        return this.interchangeDelimiters;
    }

    public void setInterchangeDelimiters(Delimiters interchangeDelimiters) {
        this.interchangeDelimiters = interchangeDelimiters;
    }

    public UNB41 getInterchangeHeader() {
        return this.interchangeHeader;
    }

    public void setInterchangeHeader(UNB41 interchangeHeader) {
        this.interchangeHeader = interchangeHeader;
    }

    public UNZ41 getInterchangeTrailer() {
        return this.interchangeTrailer;
    }

    public void setInterchangeTrailer(UNZ41 interchangeTrailer) {
        this.interchangeTrailer = interchangeTrailer;
    }

    public List<UNEdifactMessage41> getMessages() {
        return this.messages;
    }

    public void setMessages(List<UNEdifactMessage41> messages) {
        this.messages = messages;
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.write(writer, this.interchangeDelimiters);
    }

    @Override
    public void write(Writer writer, Delimiters delimiters) throws IOException {
        AssertArgument.isNotNull((Object)writer, (String)"writer");
        if (delimiters != null && delimiters != UNEdifactInterchangeParser.defaultUNEdifactDelimiters) {
            writer.append("UNA");
            writer.append(delimiters.getComponent());
            writer.append(delimiters.getField());
            writer.append(delimiters.getDecimalSeparator());
            writer.append(delimiters.getEscape());
            writer.append(" ");
            writer.append(delimiters.getSegment());
        } else {
            delimiters = UNEdifactInterchangeParser.defaultUNEdifactDelimiters;
        }
        if (this.interchangeHeader != null) {
            this.interchangeHeader.write(writer, delimiters);
        }
        UNEdifactMessage41 previousMessage = null;
        if (this.messages != null) {
            for (UNEdifactMessage41 message : this.messages) {
                Object messageObject = message.getMessage();
                if (messageObject == null) {
                    throw new IOException("Cannot write null EDI message object.");
                }
                if (!(messageObject instanceof EDIWritable)) {
                    throw new IOException("Cannot write EDI message object type '" + messageObject.getClass().getName() + "'.  Type must implement '" + EDIWritable.class.getName() + "'.");
                }
                if (message.getGroupHeader() != null) {
                    if (previousMessage == null) {
                        message.getGroupHeader().write(writer, delimiters);
                    } else if (message.getGroupHeader() != previousMessage.getGroupHeader()) {
                        if (previousMessage.getGroupHeader() != null) {
                            previousMessage.getGroupTrailer().write(writer, delimiters);
                        }
                        message.getGroupHeader().write(writer, delimiters);
                    }
                } else if (previousMessage != null && previousMessage.getGroupHeader() != null) {
                    previousMessage.getGroupTrailer().write(writer, delimiters);
                }
                if (message.getMessageHeader() != null) {
                    message.getMessageHeader().write(writer, delimiters);
                }
                ((EDIWritable)messageObject).write(writer, delimiters);
                if (message.getMessageTrailer() != null) {
                    message.getMessageTrailer().write(writer, delimiters);
                }
                previousMessage = message;
            }
        }
        if (previousMessage != null && previousMessage.getGroupTrailer() != null) {
            previousMessage.getGroupTrailer().write(writer, delimiters);
        }
        if (this.interchangeTrailer != null) {
            this.interchangeTrailer.write(writer, delimiters);
        }
        writer.flush();
    }
}

