/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.javabean.repository.BeanId;

public class BeanIdStore {
    private volatile HashMap<String, BeanId> beanIdMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanId register(String beanIdName) {
        AssertArgument.isNotEmpty((String)beanIdName, (String)"beanIdName");
        BeanId beanId = this.beanIdMap.get(beanIdName);
        if (beanId == null) {
            BeanIdStore beanIdStore = this;
            synchronized (beanIdStore) {
                beanId = this.beanIdMap.get(beanIdName);
                if (beanId == null) {
                    HashMap newBeanIdMap = (HashMap)this.beanIdMap.clone();
                    beanId = new BeanId(this, newBeanIdMap.size(), beanIdName);
                    newBeanIdMap.put(beanIdName, beanId);
                    this.beanIdMap = newBeanIdMap;
                }
            }
        }
        return beanId;
    }

    public BeanId getBeanId(String beanId) {
        return this.beanIdMap.get(beanId);
    }

    public boolean containsBeanId(String beanId) {
        return this.beanIdMap.containsKey(beanId);
    }

    public synchronized Map<String, BeanId> getBeanIdMap() {
        return Collections.unmodifiableMap(this.beanIdMap);
    }

    public int size() {
        return this.beanIdMap.size();
    }
}

