/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.rules.mvel;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.container.ExecutionContext;
import org.milyn.expression.ExpressionEvaluator;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.resource.URIResourceLocator;
import org.milyn.rules.RuleEvalResult;
import org.milyn.rules.RuleProvider;
import org.milyn.rules.mvel.MVELRuleEvalResult;

public class MVELProvider
implements RuleProvider {
    private static Log logger = LogFactory.getLog(MVELProvider.class);
    private String name;
    private String src;
    private Map<String, ExpressionEvaluator> rules = new HashMap<String, ExpressionEvaluator>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
        this.loadRules();
    }

    public RuleEvalResult evaluate(String ruleName, CharSequence selectedData, ExecutionContext context) throws SmooksException {
        ExpressionEvaluator evaluator = this.rules.get(ruleName);
        if (evaluator == null) {
            throw new SmooksException("Unknown rule name '" + ruleName + "' on MVEL RuleProvider '" + this.name + "'.");
        }
        try {
            return new MVELRuleEvalResult(evaluator.eval((Object)context.getBeanContext().getBeanMap()), ruleName, this.name, ((Object)selectedData).toString());
        }
        catch (Throwable t) {
            return new MVELRuleEvalResult(t, ruleName, this.name, ((Object)selectedData).toString());
        }
    }

    private void loadRules() {
        List entries;
        InputStream ruleStream;
        if (this.src == null) {
            throw new SmooksException("ruleFile not specified.");
        }
        try {
            ruleStream = new URIResourceLocator().getResource(this.src);
        }
        catch (IOException e) {
            throw new SmooksException("Failed to open rule file '" + this.src + "'.", (Throwable)e);
        }
        CSVReader csvLineReader = new CSVReader((Reader)new InputStreamReader(ruleStream));
        try {
            entries = csvLineReader.readAll();
        }
        catch (IOException e) {
            throw new SmooksConfigurationException("Error reading MVEL rule file (CSV format) '" + this.src + "'.", (Throwable)e);
        }
        finally {
            try {
                ruleStream.close();
            }
            catch (IOException e) {
                logger.debug((Object)("Error closing MVEL rule file '" + this.src + "'."), (Throwable)e);
            }
        }
        for (String[] ruleLine : entries) {
            if (ruleLine.length != 2 || ruleLine[0].trim().charAt(0) == '#') continue;
            String ruleName = ruleLine[0].trim();
            String ruleExpression = ruleLine[1];
            if (this.rules.containsKey(ruleName)) {
                logger.debug((Object)("Duplicate rule definition '" + ruleName + "' in MVEL rule file '" + ruleName + "'.  Ignoring duplicate."));
                continue;
            }
            this.rules.put(ruleName, new MVELExpressionEvaluator().setExpression(ruleExpression));
        }
    }
}

