/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.yaml;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.xml.SmooksXMLReader;
import org.milyn.yaml.AliasStrategy;
import org.milyn.yaml.ElementNameFormatter;
import org.milyn.yaml.KeyMapDigester;
import org.milyn.yaml.handler.AliasReferencingEventHandler;
import org.milyn.yaml.handler.AliasResolvingEventHandler;
import org.milyn.yaml.handler.EventHandler;
import org.milyn.yaml.handler.YamlEventStreamHandler;
import org.milyn.yaml.handler.YamlToSaxHandler;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.yaml.snakeyaml.Yaml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlReader
implements SmooksXMLReader {
    private static Log logger = LogFactory.getLog(YamlReader.class);
    public static final String CONFIG_PARAM_KEY_MAP = "keyMap";
    public static final String XML_ROOT = "yaml";
    public static final String XML_DOCUMENT = "document";
    public static final String XML_ARRAY_ELEMENT_NAME = "element";
    public static final String DEFAULT_ANCHOR_NAME = "id";
    public static final String DEFAULT_ALIAS_NAME = "ref";
    private ContentHandler contentHandler;
    private ExecutionContext executionContext;
    @ConfigParam(defaultVal="yaml")
    private String rootName;
    @ConfigParam(defaultVal="document")
    private String documentName;
    @ConfigParam(defaultVal="element")
    private String arrayElementName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String keyWhitspaceReplacement;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String keyPrefixOnNumeric;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String illegalElementNameCharReplacement;
    @ConfigParam(defaultVal="id")
    private String anchorAttributeName;
    @ConfigParam(defaultVal="ref")
    private String aliasAttributeName;
    @ConfigParam(defaultVal="false")
    private boolean indent;
    @ConfigParam(defaultVal="REFER", decoder=AliasStrategy.DataDecoder.class)
    private AliasStrategy aliasStrategy;
    @Config
    private SmooksResourceConfiguration config;
    private final Yaml yaml = new Yaml();
    private YamlEventStreamHandler yamlEventStreamParser;

    @Initialize
    public void initialize() {
        ElementNameFormatter elementNameFormatter = new ElementNameFormatter(this.initKeyMap(), this.keyWhitspaceReplacement, this.keyPrefixOnNumeric, this.illegalElementNameCharReplacement);
        this.yamlEventStreamParser = new YamlEventStreamHandler(elementNameFormatter, this.documentName, this.arrayElementName);
    }

    public void setExecutionContext(ExecutionContext request) {
        this.executionContext = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource yamlInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse YAML stream.");
        }
        if (this.executionContext == null) {
            throw new IllegalStateException("Smooks container 'executionContext' not set.  Cannot parse YAML stream.");
        }
        try {
            Reader yamlStreamReader = yamlInputSource.getCharacterStream();
            if (yamlStreamReader == null) {
                throw new SmooksException("The InputSource doesn't provide a Reader character stream. Make sure that you supply a reader to the Smooks.filterSource method.");
            }
            YamlToSaxHandler yamlToSaxHandler = new YamlToSaxHandler(this.contentHandler, this.anchorAttributeName, this.aliasAttributeName, this.indent);
            EventHandler eventHandler = this.aliasStrategy == AliasStrategy.REFER ? new AliasReferencingEventHandler(yamlToSaxHandler) : new AliasResolvingEventHandler(this.yamlEventStreamParser, yamlToSaxHandler, this.aliasStrategy == AliasStrategy.REFER_RESOLVE);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Starting YAML parsing");
            }
            Iterable yamlEventStream = this.yaml.parse(yamlStreamReader);
            this.contentHandler.startDocument();
            yamlToSaxHandler.startElementStructure(this.rootName, null, false);
            this.yamlEventStreamParser.handle(eventHandler, yamlEventStream);
            yamlToSaxHandler.endElementStructure(this.rootName);
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
            this.executionContext = null;
        }
    }

    private Map<String, String> initKeyMap() {
        Parameter keyMapParam = this.config.getParameter(CONFIG_PARAM_KEY_MAP);
        if (keyMapParam != null) {
            Object objValue = keyMapParam.getObjValue();
            if (objValue instanceof Map) {
                return (HashMap)objValue;
            }
            Element keyMapParamElement = keyMapParam.getXml();
            if (keyMapParamElement != null) {
                return KeyMapDigester.digest(keyMapParamElement);
            }
            throw new SmooksException("Sorry, the key properties must be available as XML DOM. Please configure using XML.");
        }
        return Collections.emptyMap();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public String getArrayElementName() {
        return this.arrayElementName;
    }

    public void setArrayElementName(String arrayElementName) {
        this.arrayElementName = arrayElementName;
    }

    public String getKeyWhitspaceReplacement() {
        return this.keyWhitspaceReplacement;
    }

    public void setKeyWhitspaceReplacement(String keyWhitspaceReplacement) {
        this.keyWhitspaceReplacement = keyWhitspaceReplacement;
    }

    public String getKeyPrefixOnNumeric() {
        return this.keyPrefixOnNumeric;
    }

    public void setKeyPrefixOnNumeric(String keyPrefixOnNumeric) {
        this.keyPrefixOnNumeric = keyPrefixOnNumeric;
    }

    public String getIllegalElementNameCharReplacement() {
        return this.illegalElementNameCharReplacement;
    }

    public void setIllegalElementNameCharReplacement(String illegalElementNameCharReplacement) {
        this.illegalElementNameCharReplacement = illegalElementNameCharReplacement;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

