/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.direct;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.filters.RequestResponseLogFilter;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.direct.DirectProxyUnificationHandler;
import org.mockserver.stop.StopEventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectProxy
implements Proxy {
    private static final Logger logger = LoggerFactory.getLogger(DirectProxy.class);
    private final RequestLogFilter requestLogFilter = new RequestLogFilter();
    private final RequestResponseLogFilter requestResponseLogFilter = new RequestResponseLogFilter();
    private final SettableFuture<String> hasStarted;
    private final SettableFuture<String> stopping = SettableFuture.create();
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private StopEventQueue stopEventQueue = new StopEventQueue();
    private Channel channel;
    private InetSocketAddress remoteSocket;

    public DirectProxy(final Integer localPort, final String remoteHost, final Integer remotePort) {
        if (localPort == null) {
            throw new IllegalArgumentException("You must specify a local port");
        }
        if (remoteHost == null) {
            throw new IllegalArgumentException("You must specify a remote port");
        }
        if (remotePort == null) {
            throw new IllegalArgumentException("You must specify a remote hostname");
        }
        this.hasStarted = SettableFuture.create();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DirectProxy.this.remoteSocket = new InetSocketAddress(remoteHost, (int)remotePort);
                    DirectProxy.this.channel = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(DirectProxy.this.bossGroup, DirectProxy.this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new DirectProxyUnificationHandler()).childAttr(Proxy.HTTP_PROXY, (Object)DirectProxy.this).childAttr(Proxy.REMOTE_SOCKET, (Object)DirectProxy.this.remoteSocket).childAttr(Proxy.REQUEST_LOG_FILTER, (Object)DirectProxy.this.requestLogFilter).childAttr(Proxy.REQUEST_RESPONSE_LOG_FILTER, (Object)DirectProxy.this.requestResponseLogFilter).bind(localPort.intValue()).syncUninterruptibly().channel();
                    logger.info("MockServer proxy started on port: {} connected to remote server: {}", (Object)((InetSocketAddress)DirectProxy.this.channel.localAddress()).getPort(), (Object)(remoteHost + ":" + remotePort));
                    DirectProxy.this.hasStarted.set((Object)"STARTED");
                    DirectProxy.this.channel.closeFuture().syncUninterruptibly();
                }
                finally {
                    DirectProxy.this.bossGroup.shutdownGracefully().syncUninterruptibly();
                    DirectProxy.this.workerGroup.shutdownGracefully().syncUninterruptibly();
                }
            }
        }, "MockServer DirectProxy Thread").start();
        try {
            this.hasStarted.get();
        }
        catch (Exception e) {
            logger.warn("Exception while waiting for MockServer proxy to complete starting up", (Throwable)e);
        }
    }

    @Override
    public Future<?> stop() {
        return this.stopEventQueue.stop(this, this.stopping, this.bossGroup, this.workerGroup);
    }

    public DirectProxy withStopEventQueue(StopEventQueue stopEventQueue) {
        this.stopEventQueue = stopEventQueue;
        this.stopEventQueue.register(this);
        return this;
    }

    @Override
    public boolean isRunning() {
        return !this.bossGroup.isShuttingDown() || !this.workerGroup.isShuttingDown() || !this.stopping.isDone();
    }

    public Integer getLocalPort() {
        return ((InetSocketAddress)this.channel.localAddress()).getPort();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }
}

