/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.filters.LogFilter;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mockserver.MockServer;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MockServer server;
    private LogFilter logFilter;
    private MockServerMatcher mockServerMatcher;
    private ActionHandler actionHandler;
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public MockServerHandler(MockServer server, MockServerMatcher mockServerMatcher, LogFilter logFilter) {
        this.mockServerMatcher = mockServerMatcher;
        this.server = server;
        this.logFilter = logFilter;
        this.actionHandler = new ActionHandler(logFilter);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        try {
            if (request.matches("PUT", "/status")) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/expectation")) {
                Expectation expectation = this.expectationSerializer.deserialize(request.getBodyAsString());
                this.mockServerMatcher.when(expectation.getHttpRequest(), expectation.getTimes()).thenRespond(expectation.getHttpResponse(false)).thenForward(expectation.getHttpForward()).thenCallback(expectation.getHttpCallback());
                this.writeResponse(ctx, request, HttpResponseStatus.CREATED);
            } else if (request.matches("PUT", "/clear")) {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                this.logFilter.clear(httpRequest);
                this.mockServerMatcher.clear(httpRequest);
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/reset")) {
                this.logFilter.reset();
                this.mockServerMatcher.reset();
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/dumpToLog")) {
                this.mockServerMatcher.dumpToLog(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
            } else if (request.matches("PUT", "/retrieve")) {
                Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.OK, this.expectationSerializer.serialize(expectations), "application/json");
            } else if (request.matches("PUT", "/verify")) {
                String result = this.logFilter.verify(this.verificationSerializer.deserialize(request.getBodyAsString()));
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, "plain/text");
                }
            } else if (request.matches("PUT", "/verifySequence")) {
                String result = this.logFilter.verify(this.verificationSequenceSerializer.deserialize(request.getBodyAsString()));
                if (result.isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else {
                    this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, "plain/text");
                }
            } else if (request.matches("PUT", "/stop")) {
                this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                ctx.flush();
                ctx.close();
                this.server.stop();
            } else {
                this.writeResponse(ctx, request, this.actionHandler.processAction(this.mockServerMatcher.handle(request), request));
            }
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + request, (Throwable)e);
            this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST);
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (!body.isEmpty()) {
            response.withHeader(Header.header((String)"Content-Type", (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        this.writeResponse(ctx, request, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (response.getHeader("Content-Length").isEmpty()) {
            response.withHeader(Header.header((String)"Content-Length", (int)response.getBody().getRawBytes().length));
        }
        if (request.isKeepAlive()) {
            response.withHeader(Header.header((String)"Connection", (String[])new String[]{"keep-alive"}));
            ctx.write((Object)response);
        } else {
            response.withHeader(Header.header((String)"Connection", (String[])new String[]{"close"}));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().contains("Connection reset by peer")) {
            this.logger.warn("Exception caught by MockServer handler closing pipeline", cause);
        }
        ctx.close();
    }
}

