/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.NettySslContextFactory;
import org.mockserver.unification.PortUnificationHandler;

public class UpstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final MockServerLogger mockServerLogger;
    private volatile Channel upstreamChannel;
    private volatile Channel downstreamChannel;

    public UpstreamProxyRelayHandler(MockServerLogger mockServerLogger, Channel upstreamChannel, Channel downstreamChannel) {
        super(false);
        this.upstreamChannel = upstreamChannel;
        this.downstreamChannel = downstreamChannel;
        this.mockServerLogger = mockServerLogger;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead0(final ChannelHandlerContext ctx, final FullHttpRequest request) {
        if (PortUnificationHandler.isSslEnabledDownstream(this.upstreamChannel) && this.downstreamChannel.pipeline().get(SslHandler.class) == null) {
            this.downstreamChannel.pipeline().addFirst(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createClientSslContext().newHandler(ctx.alloc())});
        }
        this.downstreamChannel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    if (UpstreamProxyRelayHandler.this.isNotSocketClosedException(future.cause())) {
                        UpstreamProxyRelayHandler.this.mockServerLogger.error("Exception while returning response for request \"" + request.method() + " " + request.uri() + "\"", future.cause());
                    }
                    future.channel().close();
                }
            }
        });
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandler.closeOnFlush(this.downstreamChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.error("Exception caught by upstream relay handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

