/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.mockftpserver.core.CommandSyntaxException;
import org.mockftpserver.core.MockFtpServerException;
import org.mockftpserver.core.util.HostAndPort;

public final class PortParser {
    public static HostAndPort parseExtendedAddressHostAndPort(String parameter) {
        InetAddress host;
        if (parameter == null || parameter.length() == 0) {
            throw new CommandSyntaxException("The parameter string must not be empty or null");
        }
        String delimiter = parameter.substring(0, 1);
        String[] tokens = parameter.split("\\" + delimiter);
        if (tokens.length < 4) {
            throw new CommandSyntaxException("Error parsing host and port number [" + parameter + "]");
        }
        int port = Integer.parseInt(tokens[3]);
        try {
            host = InetAddress.getByName(tokens[2]);
        }
        catch (UnknownHostException e) {
            throw new CommandSyntaxException("Error parsing host [" + tokens[2] + "]", e);
        }
        return new HostAndPort(host, port);
    }

    public static HostAndPort parseHostAndPort(String[] parameters) {
        PortParser.verifySufficientParameters(parameters);
        byte host1 = PortParser.parseByte(parameters[0]);
        byte host2 = PortParser.parseByte(parameters[1]);
        byte host3 = PortParser.parseByte(parameters[2]);
        byte host4 = PortParser.parseByte(parameters[3]);
        byte[] address = new byte[]{host1, host2, host3, host4};
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new MockFtpServerException("Error parsing host", e);
        }
        int port1 = Integer.parseInt(parameters[4]);
        int port2 = Integer.parseInt(parameters[5]);
        int port = (port1 << 8) + port2;
        return new HostAndPort(inetAddress, port);
    }

    public static String convertHostAndPortToCommaDelimitedBytes(InetAddress host, int port) {
        StringBuffer buffer = new StringBuffer();
        byte[] address = host.getAddress();
        for (int i = 0; i < address.length; ++i) {
            int positiveValue = address[i] >= 0 ? address[i] : 256 + address[i];
            buffer.append(positiveValue);
            buffer.append(",");
        }
        int p1 = port >> 8;
        int p2 = port % 256;
        buffer.append(String.valueOf(p1));
        buffer.append(",");
        buffer.append(String.valueOf(p2));
        return buffer.toString();
    }

    private static void verifySufficientParameters(String[] parameters) {
        if (parameters == null || parameters.length < 6) {
            List<String> parms = parameters == null ? null : Arrays.asList(parameters);
            throw new CommandSyntaxException("The PORT command must contain least be 6 parameters: " + parms);
        }
    }

    private static byte parseByte(String string) {
        return (byte)(0xFF & Short.parseShort(string));
    }

    private PortParser() {
    }
}

